/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.tile;

import java.util.List;
import mariculture.core.Core;
import mariculture.core.config.Machines;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.SpawnItemHelper;
import mariculture.core.helpers.cofh.InventoryHelper;
import mariculture.core.network.PacketHandler;
import mariculture.core.tile.base.TileTank;
import mariculture.core.util.Fluids;
import mariculture.core.util.IFaceable;
import mariculture.core.util.Tank;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLogic;
import net.minecraft.block.material.MaterialTransparent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileGeyser
extends TileTank
implements IFaceable {
    public ForgeDirection orientation = ForgeDirection.UP;
    private int machineTick;
    private boolean canWork;
    private int size;

    public TileGeyser() {
        this.tank = new Tank(8000);
    }

    public boolean onTick(int i) {
        return this.machineTick % i == 0;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public boolean canWork() {
        return this.tank.getFluidAmount() > 0 && this.canUseFluid(this.tank.getFluidID()) && !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private boolean canUseFluid(int id) {
        if (id == FluidRegistry.getFluidID((String)"water")) {
            this.size = 8;
            return true;
        }
        if (id == Fluids.getFluidID("hp_water")) {
            this.size = 16;
            return true;
        }
        return false;
    }

    private boolean isNet(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == Core.ticking;
    }

    public void func_145845_h() {
        ++this.machineTick;
        if (this.onTick(20)) {
            this.canWork = this.canWork();
        }
        if (this.canWork) {
            this.doSquirt();
            if (this.onTick(100)) {
                this.drain(ForgeDirection.UP, new FluidStack(this.tank.getFluidID(), 1), true);
                if (this.tank.getFluidAmount() <= 0) {
                    PacketHandler.syncFluids(this, this.getFluid());
                }
                this.pullFromInventory();
            }
        }
    }

    private void doSquirt() {
        for (int dist = 0; dist < this.size; ++dist) {
            float i;
            Material mat;
            double x = this.field_145851_c + this.orientation.offsetX * dist;
            double y = this.field_145848_d + this.orientation.offsetY * dist;
            double z = this.field_145849_e + this.orientation.offsetZ * dist;
            if (!(dist <= 0 || (mat = this.field_145850_b.func_147439_a((int)x, (int)y, (int)z).func_149688_o()) instanceof MaterialLogic || mat instanceof MaterialTransparent || this.isNet((int)x, (int)y, (int)z))) {
                return;
            }
            List list = this.field_145850_b.func_72872_a(Entity.class, Blocks.field_150348_b.func_149668_a(this.field_145850_b, (int)x, (int)y, (int)z));
            for (Object i2 : list) {
                Entity entity = (Entity)i2;
                entity.field_70143_R = 0.0f;
                if (this.orientation != ForgeDirection.UP) {
                    entity.func_70024_g((double)this.orientation.offsetX * 0.1, (double)this.orientation.offsetY * 0.1, (double)this.orientation.offsetZ * 0.1);
                    continue;
                }
                if (!(entity.field_70181_x <= 0.24)) continue;
                entity.field_70181_x += 0.25;
                if (!(entity instanceof EntityItem)) continue;
                entity.field_70181_x += 0.015;
                entity.field_70159_w = 0.0;
                entity.field_70179_y = 0.0;
            }
            if (!Machines.Client.GEYSER_ANIM || !this.field_145850_b.field_72995_K || !this.onTick(4)) continue;
            float f = i = dist > 0 ? -0.45f : -0.1f;
            while (i <= 0.35f) {
                this.field_145850_b.func_72869_a("cloud", x + 0.5 + (double)(i * (float)this.orientation.offsetX), y + 0.5 + (double)(i * (float)this.orientation.offsetY), z + 0.5 + (double)(i * (float)this.orientation.offsetZ), 0.0, 0.0, 0.0);
                i += 0.05f;
            }
        }
    }

    public void pullFromInventory() {
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c - this.orientation.offsetX, this.field_145848_d - this.orientation.offsetY, this.field_145849_e - this.orientation.offsetZ);
        if (tile != null) {
            if (tile instanceof IInventory) {
                ItemStack stack = InventoryHelper.extractItemStackFromInventory((IInventory)tile, this.orientation.getOpposite().ordinal());
                if (stack != null) {
                    SpawnItemHelper.spawnItem(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, stack, false);
                }
            } else if (tile instanceof IFluidHandler) {
                FluidStack fluid;
                IFluidHandler handler = (IFluidHandler)tile;
                if (this.tank.getFluidAmount() + 1000 < this.tank.getCapacity() && (fluid = handler.drain(this.orientation.getOpposite(), 1000, true)) != null) {
                    this.tank.fill(fluid, true);
                }
            }
        }
    }

    @Override
    public boolean rotate() {
        this.setFacing(BlockHelper.rotate(this.orientation));
        return true;
    }

    @Override
    public ForgeDirection getFacing() {
        return this.orientation;
    }

    @Override
    public void setFacing(ForgeDirection dir) {
        this.orientation = dir;
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.updateOrientation(this);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.orientation = ForgeDirection.getOrientation((int)nbt.func_74762_e("Orientation"));
        this.canWork = nbt.func_74767_n("CanWork");
        this.size = nbt.func_74762_e("Size");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Orientation", this.orientation.ordinal());
        nbt.func_74757_a("CanWork", this.canWork);
        nbt.func_74768_a("Size", this.size);
    }
}

