/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.tile;

import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.tile.base.TileMultiBlock;
import mariculture.core.tile.base.TileMultiMachineTank;
import mariculture.core.util.Fluids;
import mariculture.factory.items.ItemArmorFLUDD;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;

public class TilePressureVessel
extends TileMultiMachineTank {
    private static final int in = 3;
    private static final int out = 4;
    private static final int fludd = 5;

    public TilePressureVessel() {
        this.inventory = new ItemStack[6];
        this.setting = FeatureEject.EjectSetting.NONE;
        this.mode = FeatureRedstone.RedstoneMode.DISABLED;
    }

    @Override
    public int getTankCapacity(int storage) {
        int tankRate = 1000;
        return (140 * tankRate + storage * 8 * tankRate) * (this.slaves.size() + 1);
    }

    @Override
    public void updateMasterMachine() {
    }

    @Override
    public void updateSlaveMachine() {
    }

    public int[] func_94128_d(int side) {
        return new int[]{3, 4, 5};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (slot == 3) {
            return FluidHelper.isFluidOrEmpty(stack);
        }
        return slot == 5;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot >= 4;
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.FLUID;
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        TilePressureVessel mstr;
        TilePressureVessel tilePressureVessel = mstr = this.getMaster() != null ? (TilePressureVessel)this.getMaster() : null;
        if (mstr == null) {
            return;
        }
        mstr.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > mstr.func_70297_j_()) {
            stack.field_77994_a = mstr.func_70297_j_();
        }
        this.fillFLUDD();
        FluidHelper.process(this, 3, 4);
        this.updateUpgrades();
        mstr.func_70296_d();
    }

    @Override
    public Packet func_145844_m() {
        this.fillFLUDD();
        FluidHelper.process(this, 3, 4);
        this.updateUpgrades();
        return super.func_145844_m();
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    private void fillFLUDD() {
        if (this.inventory[5] != null && this.inventory[5].func_77973_b() instanceof ItemArmorFLUDD && this.tank.getFluidID() == Fluids.getFluidID("hp_water") && this.tank.getFluidAmount() > 0) {
            ItemStack stack = this.inventory[5].func_77946_l();
            int water = 0;
            if (stack.func_77942_o()) {
                water = stack.field_77990_d.func_74762_e("water");
            } else {
                stack.func_77982_d(new NBTTagCompound());
            }
            int drain = 20000 - water;
            if (drain > 0 && this.tank.getFluidAmount() == drain) {
                this.tank.drain(drain, true);
                stack.field_77990_d.func_74768_a("water", 20000);
            }
            this.inventory[5] = stack;
        }
    }

    @Override
    public boolean canWork() {
        return false;
    }

    private TilePressureVessel isSameBlock(int x, int y, int z) {
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        return tile != null && tile instanceof TilePressureVessel ? (TilePressureVessel)tile : null;
    }

    private boolean tryToAdd(int x, int y, int z) {
        TilePressureVessel neighbour = this.isSameBlock(x, y, z);
        if (neighbour != null) {
            this.master = neighbour.master;
            TilePressureVessel mstr = (TilePressureVessel)this.getMaster();
            mstr.addSlave(new TileMultiBlock.MultiPart(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            return true;
        }
        return false;
    }

    @Override
    public void onBlockPlaced() {
        if (this.tryToAdd(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        if (this.tryToAdd(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        if (this.tryToAdd(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)) {
            return;
        }
        if (this.tryToAdd(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)) {
            return;
        }
        if (this.tryToAdd(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            return;
        }
        if (this.tryToAdd(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) {
            return;
        }
        this.master = new TileMultiBlock.MultiPart(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onBlockBreak() {
        block3: {
            TileMultiBlock master;
            block4: {
                if (this.getMaster() == null) break block3;
                master = this.getMaster();
                if (!((Object)((Object)master)).equals(this)) break block4;
                if (this.slaves.size() <= 0) break block3;
                TileMultiBlock.MultiPart coords = (TileMultiBlock.MultiPart)this.slaves.get(0);
                this.slaves.remove(0);
                for (TileMultiBlock.MultiPart slave : this.slaves) {
                    TilePressureVessel vessel = (TilePressureVessel)this.field_145850_b.func_147438_o(slave.xCoord, slave.yCoord, slave.zCoord);
                    if (vessel == null) continue;
                    vessel.setMaster(new TileMultiBlock.MultiPart(coords.xCoord, coords.yCoord, coords.zCoord));
                }
                this.master = coords;
                NBTTagCompound contents = new NBTTagCompound();
                this.func_145841_b(contents);
                contents.func_74768_a("x", coords.xCoord);
                contents.func_74768_a("y", coords.yCoord);
                contents.func_74768_a("z", coords.zCoord);
                TilePressureVessel theMaster = (TilePressureVessel)this.field_145850_b.func_147438_o(coords.xCoord, coords.yCoord, coords.zCoord);
                if (theMaster != null) {
                    theMaster.func_145839_a(contents);
                }
                break block3;
            }
            for (TileMultiBlock.MultiPart part : master.getSlaves()) {
                if (part.xCoord != this.field_145851_c || part.yCoord != this.field_145848_d || part.zCoord != this.field_145849_e) continue;
                master.removeSlave(part);
                break;
            }
        }
    }
}

