/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.TileEnergyHandler;
import mariculture.core.lib.Modules;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;

public class TileSponge
extends TileEnergyHandler {
    boolean posXFound;
    boolean negXFound;
    boolean posZFound;
    boolean negZFound;
    boolean posYFound = false;
    int posX;
    int negX;
    int posZ;
    int negZ;
    int posY = 0;
    private int tick;

    public TileSponge() {
        this.storage = new EnergyStorage(0, 5000, Integer.MAX_VALUE);
    }

    public boolean isBlockSponge(int x, int y, int z) {
        if (Modules.isActive(Modules.worldplus)) {
            return this.field_145850_b.func_147439_a(x, y, z) == Blocks.field_150360_v;
        }
        return this.field_145850_b.func_147439_a(x, y, z) == Blocks.field_150325_L && this.field_145850_b.func_72805_g(x, y, z) == 4;
    }

    public void updateCoords() {
        this.posXFound = false;
        this.negXFound = false;
        this.posZFound = false;
        this.negZFound = false;
        this.posYFound = false;
        for (int i = 0; i < 48; ++i) {
            if (!this.posXFound && this.isBlockSponge(this.field_145851_c + i, this.field_145848_d, this.field_145849_e)) {
                this.posXFound = true;
                this.posX = this.field_145851_c + i;
            }
            if (!this.negXFound && this.isBlockSponge(this.field_145851_c - i, this.field_145848_d, this.field_145849_e)) {
                this.negXFound = true;
                this.negX = this.field_145851_c - i;
            }
            if (!this.posZFound && this.isBlockSponge(this.field_145851_c, this.field_145848_d, this.field_145849_e + i)) {
                this.posZFound = true;
                this.posZ = this.field_145849_e + i;
            }
            if (!this.negZFound && this.isBlockSponge(this.field_145851_c, this.field_145848_d, this.field_145849_e - i)) {
                this.negZFound = true;
                this.negZ = this.field_145849_e - i;
            }
            if (this.posYFound || !this.isBlockSponge(this.field_145851_c, this.field_145848_d + i, this.field_145849_e)) continue;
            this.posYFound = true;
            this.posY = this.field_145848_d + i;
        }
    }

    public void clearWater() {
        for (int x = this.negX; x <= this.posX; ++x) {
            for (int z = this.negZ; z <= this.posZ; ++z) {
                for (int y = this.field_145848_d; y <= this.posY; ++y) {
                    if (!this.field_145850_b.func_147439_a(x, y, z).func_149688_o().func_76224_d() && this.field_145850_b.func_147439_a(x, y, z) != Blocks.field_150360_v) continue;
                    this.field_145850_b.func_147468_f(x, y, z);
                }
            }
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tick % 50 == 0) {
                this.updateCoords();
            }
            ++this.tick;
            if (this.tick % 200 == 0) {
                if (this.posXFound && this.negXFound && this.posZFound && this.negZFound && this.posYFound) {
                    int powerX = Math.max(this.posX, this.negX) - Math.min(this.posX, this.negX);
                    int powerZ = Math.max(this.posZ, this.negZ) - Math.min(this.posZ, this.negZ);
                    int powerY = Math.max(this.field_145848_d, this.posY) - Math.min(this.field_145848_d, this.posY);
                    int power = powerX * powerZ * powerY * 40;
                    this.storage.setCapacity(power);
                    if (this.storage.extractEnergy(power, true) >= power) {
                        this.clearWater();
                        this.storage.extractEnergy(power, false);
                        this.storage.setCapacity(0);
                    }
                } else {
                    this.storage.setCapacity(0);
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.storage.readFromNBT(tagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.storage.writeToNBT(tagCompound);
    }
}

