/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery;

import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import mariculture.Mariculture;
import mariculture.api.core.Environment;
import mariculture.api.core.IUpgradable;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.IFishHelper;
import mariculture.api.fishery.IIncubator;
import mariculture.api.fishery.IMutation;
import mariculture.api.fishery.fish.FishDNABase;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.handlers.LogHandler;
import mariculture.core.helpers.AverageHelper;
import mariculture.fishery.Fish;
import mariculture.fishery.Fishery;
import mariculture.fishery.items.ItemEgg;
import mariculture.fishery.items.ItemFishy;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class FishyHelper
implements IFishHelper {
    public static int MALE = 0;
    public static int FEMALE = 1;
    private static final String CATEGORY = "Fish-Mappings";
    private static final String COMMENT = "Mariculture Fish all have IDs, this is required mostly for when they are dead. Fish IDs are assigned automatically by Mariculture, so you can just ignore this file, it's mostly being used to save them";
    private static ArrayList<CachedFishData> cache = new ArrayList();
    private static ArrayList<Integer> taken = new ArrayList();

    @Override
    public FishSpecies registerFish(String modid, Class<? extends FishSpecies> fish) {
        return this.registerFish(modid, fish, 50);
    }

    @Override
    public FishSpecies registerFish(String modid, Class<? extends FishSpecies> fish, int default_id) {
        try {
            FishSpecies species = fish.newInstance().setup(modid);
            int fish_id = this.getID(modid, species.getSpecies());
            if (fish_id >= 0) {
                taken.add(fish_id);
            }
            cache.add(new CachedFishData(modid, species, default_id));
            return species;
        }
        catch (Exception e) {
            LogHandler.log(Level.WARN, "Mariculture failed to add the fish: " + fish + " , The fish returned null, you will have serious problems with fish!!!");
            return null;
        }
    }

    @Override
    public void registerFishies() {
        for (CachedFishData data : cache) {
            int fish_id = this.getID(data.modid, data.species.getSimpleName());
            if (fish_id < 0) {
                fish_id = this.setID(data.modid, data.species.getSimpleName(), this.getNextAvailableID(data.default_id));
            }
            FishSpecies.ids.put(data.species.getSpecies(), fish_id);
            FishSpecies.species.put(fish_id, data.species);
        }
        taken = null;
        cache = null;
    }

    private int getNextAvailableID(int default_id) {
        for (Integer taken : FishyHelper.taken) {
            if (default_id != taken) continue;
            if (default_id >= 32000) {
                return this.getNextAvailableID(0);
            }
            return this.getNextAvailableID(default_id + 1);
        }
        taken.add(default_id);
        return default_id;
    }

    private int getID(String modid, String fish) {
        Configuration config = new Configuration(new File(Mariculture.root + "/mariculture/", "fish-mappings.cfg"));
        try {
            config.load();
            return config.get(CATEGORY, modid + ":" + fish, -1).getInt();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setID(String modid, String fish, int default_id) {
        Configuration config = new Configuration(new File(Mariculture.root + "/mariculture/", "fish-mappings.cfg"));
        try {
            config.load();
            config.addCustomCategoryComment(CATEGORY, COMMENT);
            default_id = config.get(CATEGORY, modid + ":" + fish, default_id).getInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            config.save();
        }
        return default_id;
    }

    @Override
    public ItemStack makePureFish(FishSpecies species) {
        ItemStack fishStack = new ItemStack(Fishery.fishy);
        if (!fishStack.func_77942_o()) {
            fishStack.func_77982_d(new NBTTagCompound());
        }
        for (int i = 0; i < FishDNABase.DNAParts.size(); ++i) {
            FishDNABase.DNAParts.get(i).addDNA(fishStack, FishDNABase.DNAParts.get(i).getDNAFromSpecies(species));
            FishDNABase.DNAParts.get(i).addLowerDNA(fishStack, FishDNABase.DNAParts.get(i).getDNAFromSpecies(species));
        }
        return fishStack;
    }

    @Override
    public ItemStack makeBredFish(ItemStack egg, Random rand, double modifier) {
        int i;
        ItemStack fish = new ItemStack(Fishery.fishy);
        for (i = 0; i < FishDNABase.DNAParts.size(); ++i) {
            if (FishDNABase.DNAParts.get(i).hasEggData(egg)) continue;
            return null;
        }
        for (i = 0; i < FishDNABase.DNAParts.size(); ++i) {
            int[] DNAlist = FishDNABase.DNAParts.get(i).getDNAList(egg);
            int parent1DNA = DNAlist[rand.nextInt(2)];
            int parent2DNA = DNAlist[rand.nextInt(2) + 2];
            int[] babyDNA = FishDNABase.DNAParts.get(i).attemptMutation(parent1DNA, parent2DNA);
            FishDNABase.DNAParts.get(i).addDNA(fish, babyDNA[0]);
            FishDNABase.DNAParts.get(i).addLowerDNA(fish, babyDNA[1]);
        }
        int species1 = Fish.species.getDNA(fish);
        int species2 = Fish.species.getLowerDNA(fish);
        ArrayList<IMutation.Mutation> mutations = Fishing.mutation.getMutations(FishSpecies.species.get(species1), FishSpecies.species.get(species2));
        if (species1 != species2 && mutations != null && mutations.size() > 0) {
            for (IMutation.Mutation mute : mutations) {
                int i2;
                FishSpecies baby = Fishing.fishHelper.getSpecies(mute.baby);
                if (baby == null) continue;
                if ((double)rand.nextInt(1000) < mute.chance * 10.0 * modifier) {
                    for (i2 = 0; i2 < FishDNABase.DNAParts.size(); ++i2) {
                        FishDNABase.DNAParts.get(i2).addDNA(fish, FishDNABase.DNAParts.get(i2).getDNAFromSpecies(baby));
                    }
                }
                if (!((double)rand.nextInt(1000) < mute.chance * 10.0 * modifier)) continue;
                for (i2 = 0; i2 < FishDNABase.DNAParts.size(); ++i2) {
                    FishDNABase.DNAParts.get(i2).addLowerDNA(fish, FishDNABase.DNAParts.get(i2).getDNAFromSpecies(baby));
                }
            }
        }
        for (int i3 = 0; i3 < FishDNABase.DNAParts.size(); ++i3) {
            int dna1 = FishDNABase.DNAParts.get(i3).getDNA(fish);
            int dna2 = FishDNABase.DNAParts.get(i3).getLowerDNA(fish);
            int[] dominance = FishDNABase.DNAParts.get(i3).getDominant(dna1, dna2, rand);
            FishDNABase.DNAParts.get(i3).addDNA(fish, dominance[0]);
            FishDNABase.DNAParts.get(i3).addLowerDNA(fish, dominance[1]);
        }
        Fish.gender.addDNA(fish, rand.nextInt(2));
        return fish;
    }

    @Override
    public boolean canLive(World world, int x, int y, int z, ItemStack stack) {
        FishSpecies fish = Fishing.fishHelper.getSpecies(stack);
        if (fish == null) {
            return false;
        }
        Environment.Salinity salt = MaricultureHandlers.environment.getSalinity(world, x, z);
        int temperature = MaricultureHandlers.environment.getTemperature(world, x, y, z);
        boolean worldCorrect = fish.isValidDimensionForWork(world);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof IUpgradable) {
            IUpgradable upgradable = (IUpgradable)tile;
            temperature += MaricultureHandlers.upgrades.getData("temp", upgradable);
            int salinity = salt.ordinal() + MaricultureHandlers.upgrades.getData("salinity", upgradable);
            if (salinity <= 0) {
                salinity = 0;
            }
            if (salinity > 2) {
                salinity = 2;
            }
            salt = Environment.Salinity.values()[salinity];
            if (!worldCorrect) {
                worldCorrect = MaricultureHandlers.upgrades.hasUpgrade("ethereal", upgradable);
            }
        }
        if (!worldCorrect || !fish.canWorkAtThisTime(world.func_72935_r())) {
            return false;
        }
        return MaricultureHandlers.environment.matches(salt, temperature, fish.salinity, fish.temperature);
    }

    @Override
    public boolean isPure(ItemStack stack) {
        FishSpecies active = FishSpecies.species.get(Fish.species.getDNA(stack));
        FishSpecies inactive = FishSpecies.species.get(Fish.species.getLowerDNA(stack));
        return stack.func_77942_o() && stack.field_77990_d.func_74762_e("SpeciesID") == stack.field_77990_d.func_74762_e("lowerSpeciesID");
    }

    @Override
    public boolean isMale(ItemStack stack) {
        return this.getSpecies(stack) != null && Fish.gender.getDNA(stack) == MALE;
    }

    @Override
    public boolean isFemale(ItemStack stack) {
        return this.getSpecies(stack) != null && Fish.gender.getDNA(stack) == FEMALE;
    }

    @Override
    public boolean isEgg(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemEgg && stack.func_77942_o();
    }

    @Override
    public ItemStack generateEgg(ItemStack fish1, ItemStack fish2) {
        ItemStack egg = new ItemStack(Fishery.fishEggs);
        egg.func_77982_d(new NBTTagCompound());
        for (int i = 0; i < FishDNABase.DNAParts.size(); ++i) {
            int[] DNAlist = new int[]{FishDNABase.DNAParts.get(i).getDNA(fish1), FishDNABase.DNAParts.get(i).getLowerDNA(fish1), FishDNABase.DNAParts.get(i).getDNA(fish2), FishDNABase.DNAParts.get(i).getLowerDNA(fish2)};
            FishDNABase.DNAParts.get(i).addDNAList(egg, DNAlist);
        }
        int[] fertility = egg.field_77990_d.func_74759_k(Fish.fertility.getEggString());
        int eggLife = AverageHelper.getMode(fertility);
        egg.field_77990_d.func_74768_a("currentFertility", eggLife);
        egg.field_77990_d.func_74768_a("malesGenerated", 0);
        egg.field_77990_d.func_74768_a("femalesGenerated", 0);
        return egg;
    }

    @Override
    public ItemStack attemptToHatchEgg(ItemStack egg, Random rand, double mutation, IIncubator tile) {
        int[] fertility = egg.field_77990_d.func_74759_k(Fish.fertility.getEggString());
        int[] lifes = egg.field_77990_d.func_74759_k(Fish.lifespan.getEggString());
        if (egg.func_77978_p().func_74764_b("SpeciesList")) {
            ItemStack fish;
            int birthChance = 1 + tile.getBirthChanceBoost();
            egg.func_77978_p().func_74768_a("currentFertility", egg.func_77978_p().func_74762_e("currentFertility") - 1);
            if (rand.nextInt(1000) < birthChance) {
                fish = Fishing.fishHelper.makeBredFish(egg, rand, mutation);
                if (fish != null) {
                    int dna = Fish.gender.getDNA(fish);
                    tile.eject(fish);
                    if (dna == MALE) {
                        egg.func_77978_p().func_74768_a("malesGenerated", egg.func_77978_p().func_74762_e("malesGenerated") + 1);
                    } else if (dna == FEMALE) {
                        egg.func_77978_p().func_74768_a("femalesGenerated", egg.func_77978_p().func_74762_e("femalesGenerated") + 1);
                    }
                } else {
                    tile.eject(new ItemStack(Items.field_151115_aP, 2, 0));
                }
            }
            if (egg.func_77978_p().func_74762_e("currentFertility") == 0) {
                fish = Fishing.fishHelper.makeBredFish(egg, rand, mutation);
                if (fish != null) {
                    if (egg.func_77978_p().func_74762_e("malesGenerated") <= 0) {
                        tile.eject(Fish.gender.addDNA(fish.func_77946_l(), MALE));
                    }
                    if ((fish = Fishing.fishHelper.makeBredFish(egg, rand, mutation)) != null && egg.func_77978_p().func_74762_e("femalesGenerated") <= 0) {
                        tile.eject(Fish.gender.addDNA(fish.func_77946_l(), FEMALE));
                    }
                } else {
                    tile.eject(new ItemStack(Items.field_151115_aP));
                }
                return null;
            }
        }
        return egg;
    }

    @Override
    public FishSpecies getSpecies(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null || !stack.func_77942_o() || !(stack.func_77973_b() instanceof ItemFishy)) {
            return null;
        }
        return this.getSpecies(Fish.species.getDNA(stack));
    }

    @Override
    public FishSpecies getSpecies(String species) {
        try {
            return this.getSpecies(FishSpecies.ids.get(species));
        }
        catch (Exception e) {
            LogHandler.log(Level.INFO, "Failed to find fish species: " + species);
            return null;
        }
    }

    @Override
    public FishSpecies getSpecies(int id) {
        return FishSpecies.species.get(id);
    }

    @Override
    public Integer getDNA(String str, ItemStack stack) {
        for (FishDNABase dna : FishDNABase.DNAParts) {
            if (!str.equals(dna.getName())) continue;
            return dna.getDNA(stack);
        }
        return -1;
    }

    @Override
    public Integer getLowerDNA(String str, ItemStack stack) {
        for (FishDNABase dna : FishDNABase.DNAParts) {
            if (!str.equals(dna.getName())) continue;
            return dna.getLowerDNA(stack);
        }
        return -1;
    }

    private static class CachedFishData {
        private String modid;
        private FishSpecies species;
        private int default_id;

        public CachedFishData(String modid, FishSpecies species, int default_id) {
            this.modid = modid;
            this.species = species;
            this.default_id = default_id;
        }
    }
}

