/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery;

import com.google.common.eventbus.EventBus;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.util.Arrays;
import java.util.Map;
import mariculture.core.handlers.LogHandler;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class VanillaOverride
extends DummyModContainer
implements IFMLLoadingPlugin,
IClassTransformer {
    private FMLDeobfuscatingRemapper remapper;

    public VanillaOverride() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "MCVanillaTweaks";
        meta.name = "Mariculture - Vanilla Tweaks";
        meta.version = "1.0";
        meta.description = "Fishies! This mod overwrites the vanilla mechanics";
        meta.authorList = Arrays.asList("joshie");
        meta.url = "http://mariculture.wikispaces.com";
        meta.screenshots = new String[0];
        meta.parent = "mariculture";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    public String[] getASMTransformerClass() {
        return new String[]{VanillaOverride.class.getName()};
    }

    public String getModContainerClass() {
        return VanillaOverride.class.getName();
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return "mariculture.core.AccessTransformers";
    }

    public byte[] transform(String className, String arg1, byte[] data) {
        this.remapper = FMLDeobfuscatingRemapper.INSTANCE;
        byte[] newData = data;
        if (className.equals("adb")) {
            LogHandler.log(Level.INFO, "Patching the vanilla class: " + className);
            newData = this.patchFishingStuff(data, true);
            if (newData != data) {
                LogHandler.log(Level.INFO, "Succesfully replaced Vanilla Fishing Rod and Fish");
            } else {
                LogHandler.log(Level.ERROR, "Failed to replace Vanilla Fishing Rod and Fish");
            }
        }
        if (className.equals("net.minecraft.item.Item")) {
            LogHandler.log(Level.INFO, "Patching the vanilla class: " + className);
            newData = this.patchFishingStuff(data, false);
            if (newData != data) {
                LogHandler.log(Level.INFO, "Succesfully replaced Vanilla Fishing Rod and Fish");
            } else {
                LogHandler.log(Level.ERROR, "Failed to replace Vanilla Fishing Rod and Fish");
            }
        }
        return newData;
    }

    public byte[] patchFishingStuff(byte[] data, boolean obfuscated) {
        String registerItems = obfuscated ? "l" : "registerItems";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(data);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean rodFound = false;
        boolean fishFound = false;
        for (int i = 0; i < classNode.methods.size(); ++i) {
            MethodNode method = (MethodNode)classNode.methods.get(i);
            if (!method.name.equals(registerItems) || !method.desc.equals("()V")) continue;
            for (int j = 0; j < method.instructions.size(); ++j) {
                AbstractInsnNode instruction = method.instructions.get(j);
                if (instruction.getType() != 9) continue;
                LdcInsnNode ldcInstruction = (LdcInsnNode)instruction;
                if (ldcInstruction.cst.equals("fishing_rod")) {
                    if (!rodFound) {
                        ((TypeInsnNode)method.instructions.get((int)(j + 1))).desc = "mariculture/fishery/items/ItemVanillaRod";
                        ((MethodInsnNode)method.instructions.get((int)(j + 3))).owner = "mariculture/fishery/items/ItemVanillaRod";
                    }
                    rodFound = true;
                    continue;
                }
                if (!ldcInstruction.cst.equals("fish")) continue;
                if (!fishFound) {
                    ((TypeInsnNode)method.instructions.get((int)(j + 1))).desc = "mariculture/fishery/items/ItemVanillaFish";
                    ((MethodInsnNode)method.instructions.get((int)(j + 4))).owner = "mariculture/fishery/items/ItemVanillaFish";
                }
                fishFound = true;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

