/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.ItemLib;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FishBlaze
extends FishSpecies {
    @Override
    public int[] setSuitableTemperature() {
        return new int[]{50, 100};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH};
    }

    @Override
    public boolean isLavaFish() {
        return true;
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 15;
    }

    @Override
    public int getFertility() {
        return 350;
    }

    @Override
    public int getWaterRequired() {
        return 125;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(ItemLib.dropletNether, 10.0);
        this.addProduct(ItemLib.blazePowder, 5.0);
    }

    @Override
    public double getFishOilVolume() {
        return 1.0;
    }

    @Override
    public ItemStack getLiquifiedProduct() {
        return new ItemStack(ItemLib.blazeRod);
    }

    @Override
    public int getLiquifiedProductChance() {
        return 20;
    }

    @Override
    public int getFishMealSize() {
        return 2;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        player.func_70015_d(7);
    }

    @Override
    public int getLightValue() {
        return 1;
    }

    @Override
    public RodType getRodNeeded() {
        return RodType.SUPER;
    }

    @Override
    public boolean isWorldCorrect(World world) {
        return world.field_73011_w.field_76575_d;
    }

    @Override
    public double getCatchChance(World world, int height) {
        return 20.0;
    }
}

