/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.ItemLib;
import net.minecraft.world.World;

public class FishCatfish
extends FishSpecies {
    @Override
    public int[] setSuitableTemperature() {
        return new int[]{20, 45};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH, Environment.Salinity.BRACKISH, Environment.Salinity.SALINE};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 22;
    }

    @Override
    public int getFertility() {
        return 4000;
    }

    @Override
    public int getFoodConsumption() {
        return 2;
    }

    @Override
    public int getWaterRequired() {
        return 100;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(ItemLib.dropletWater, 8.0);
        this.addProduct(ItemLib.dropletAqua, 2.0);
        this.addProduct(ItemLib.dropletEarth, 5.0);
    }

    @Override
    public double getFishOilVolume() {
        return 1.95;
    }

    @Override
    public int getFishMealSize() {
        return 7;
    }

    @Override
    public float getFoodSaturation() {
        return 0.8f;
    }

    @Override
    public int getFoodDuration() {
        return 48;
    }

    @Override
    public RodType getRodNeeded() {
        return RodType.GOOD;
    }

    @Override
    public double getCatchChance(World world, int height) {
        return Environment.Height.isShallows(height) ? 25.0 : 0.0;
    }
}

