/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.gui;

import java.util.List;
import mariculture.core.gui.GuiMariculture;
import mariculture.core.gui.feature.FeatureBubbles;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureNotifications;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.gui.feature.FeatureTank;
import mariculture.core.gui.feature.FeatureUpgrades;
import mariculture.fishery.FishFoodHandler;
import mariculture.fishery.gui.ContainerFeeder;
import mariculture.fishery.tile.TileFeeder;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class GuiFeeder
extends GuiMariculture {
    private TileFeeder tile;

    public GuiFeeder(InventoryPlayer player, TileFeeder tile) {
        super(new ContainerFeeder(tile, player), "feeder", 10);
        this.tile = tile;
        this.features.add(new FeatureUpgrades());
        this.features.add(new FeatureBubbles(tile, 104, 17));
        this.features.add(new FeatureNotifications(tile, new FeatureNotifications.NotificationType[]{FeatureNotifications.NotificationType.NO_FOOD, FeatureNotifications.NotificationType.NO_MALE, FeatureNotifications.NotificationType.NO_FEMALE, FeatureNotifications.NotificationType.BAD_ENV}));
        this.features.add(new FeatureRedstone(tile));
        this.features.add(new FeatureEject(tile));
        this.features.add(new FeatureTank(tile, 33, 19, FeatureTank.TankSize.DOUBLE));
    }

    @Override
    public void addToolTip() {
        if (this.mouseX >= 95 && this.mouseX <= 98) {
            if (this.mouseY >= 24 && this.mouseY <= 41) {
                this.tooltip = this.tile.getTooltip(5, this.tooltip);
            }
            if (this.mouseY >= 52 && this.mouseY <= 69) {
                this.tooltip = this.tile.getTooltip(6, this.tooltip);
            }
        }
    }

    @Override
    public void addItemToolTip(ItemStack stack, List<String> list) {
        int value;
        if (stack != null && (value = FishFoodHandler.getValue(stack)) > 0) {
            list.add(StatCollector.func_74838_a((String)"mariculture.string.provides") + " " + value + " " + StatCollector.func_74838_a((String)"mariculture.string.fishFood"));
        }
    }

    @Override
    public void drawBackground(int x, int y) {
        int fish1 = this.tile.getFishLifeScaled(this.tile.func_70301_a(5), 17);
        if (fish1 > -1) {
            this.func_73729_b(x + 95, y + 24 + 17 - fish1, 0, 225 - fish1, 4, fish1 + 2);
        } else {
            this.func_73729_b(x + 95, y + 24, 4, 208, 4, 18);
        }
        int fish2 = this.tile.getFishLifeScaled(this.tile.func_70301_a(6), 17);
        if (fish2 > -1) {
            this.func_73729_b(x + 95, y + 52 + 17 - fish2, 0, 225 - fish2, 4, fish2 + 2);
        } else {
            this.func_73729_b(x + 95, y + 52, 4, 208, 4, 18);
        }
    }
}

