/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.items;

import java.util.List;
import mariculture.api.core.IItemUpgrade;
import mariculture.api.core.MaricultureTab;
import mariculture.api.util.Text;
import mariculture.core.gui.InventoryStorage;
import mariculture.core.items.ItemStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ItemTemperatureControl
extends ItemStorage
implements IItemUpgrade {
    private static final int SIZE = 5;

    public ItemTemperatureControl() {
        super(5, "tempControl");
        this.func_77637_a(MaricultureTab.tabFishery);
    }

    @Override
    public int getX(ItemStack stack) {
        return 30;
    }

    @Override
    public Slot getSlot(InventoryStorage storage, int i) {
        switch (i) {
            case 0: {
                return new SlotHeating(storage, i, 62, 26);
            }
            case 1: {
                return new SlotHeating(storage, i, 80, 26);
            }
            case 2: {
                return new SlotHeating(storage, i, 98, 26);
            }
            case 3: {
                return new SlotHeating(storage, i, 71, 44);
            }
            case 4: {
                return new SlotHeating(storage, i, 89, 44);
            }
        }
        return new Slot((IInventory)storage, i, 100, 100);
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        if (stack.func_77973_b() instanceof IItemUpgrade && !(stack.func_77973_b() instanceof ItemTemperatureControl)) {
            return this.getTemperature(stack) != 0;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        int temp;
        list.add("\u00a72" + Text.translate("temp.control"));
        if (stack.func_77942_o() && (temp = this.getTemperature(stack)) != 0) {
            if (temp > 0) {
                list.add("\u00a76+" + temp + "\u00b0C");
            }
            if (temp < 0) {
                list.add("\u00a79" + temp + "\u00b0C");
            }
        }
    }

    @Override
    public int getTemperature(ItemStack stack) {
        ItemStack[] invent;
        int temperature = 0;
        for (ItemStack item : invent = this.load(null, stack, 5)) {
            if (item == null || !(item.func_77973_b() instanceof IItemUpgrade)) continue;
            temperature += ((IItemUpgrade)item.func_77973_b()).getTemperature(item);
        }
        return temperature;
    }

    @Override
    public int getStorageCount(ItemStack stack) {
        return 0;
    }

    @Override
    public int getPurity(ItemStack stack) {
        return 0;
    }

    @Override
    public int getSpeed(ItemStack stack) {
        return 0;
    }

    @Override
    public int getRFBoost(ItemStack stack) {
        return 0;
    }

    @Override
    public int getSalinity(ItemStack stack) {
        return 0;
    }

    @Override
    public String getType(ItemStack stack) {
        return "control";
    }

    private static class SlotHeating
    extends Slot {
        private SlotHeating(IInventory inv, int id, int x, int y) {
            super(inv, id, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            if (stack.func_77973_b() instanceof IItemUpgrade && !(stack.func_77973_b() instanceof ItemTemperatureControl)) {
                return ((IItemUpgrade)stack.func_77973_b()).getTemperature(stack) != 0;
            }
            return false;
        }
    }
}

