/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.tile;

import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.RodType;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureNotifications;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.EnchantHelper;
import mariculture.core.lib.MachineSpeeds;
import mariculture.core.tile.base.TileMachinePowered;
import mariculture.core.util.IHasNotification;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileAutofisher
extends TileMachinePowered
implements IHasNotification {
    public static final int rod = 4;
    private static final int[] rod_slot = new int[]{4};
    private static final int[] bait = new int[]{5, 6, 7, 8, 9, 10};
    private static final int[] all = new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    private int baitChance;

    public TileAutofisher() {
        this.max = MachineSpeeds.getAutofisherSpeed();
        this.inventory = new ItemStack[20];
        this.setting = FeatureEject.EjectSetting.ITEM;
        this.output = new int[]{11, 12, 13, 14, 15, 16, 17, 18, 19};
    }

    @Override
    public int getRFCapacity() {
        return 20000;
    }

    public int[] func_94128_d(int side) {
        return side <= 1 ? rod_slot : all;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (slot == 4) {
            return Fishing.fishing.getRodType(stack) != null;
        }
        if (slot >= 5 && slot <= 10) {
            return Fishing.fishing.getBaitQuality(stack) > 0;
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 4 || slot > 10;
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.ITEM;
    }

    @Override
    public void process() {
        int speed = 1 + EnchantHelper.getLevel(Enchantment.field_151369_A, this.inventory[4]);
        for (int i = 0; i < speed && this.canWork; ++i) {
            int baitSlot = this.destroyBait();
            int bonusQuality = this.getBait() + EnchantHelper.getLevel(Enchantment.field_151370_z, this.inventory[4]) * 4;
            if (this.field_145850_b.field_73012_v.nextInt(100) >= bonusQuality || baitSlot < 0) continue;
            RodType type = Fishing.fishing.getRodType(this.inventory[4]);
            ItemStack lootResult = Fishing.fishing.getCatch(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, null, this.inventory[4]);
            this.func_70299_a(4, type.damage(this.field_145850_b, null, this.inventory[4], 0, this.field_145850_b.field_73012_v));
            if (lootResult == null) continue;
            this.func_70298_a(this.destroyBait(), 1);
            this.helper.insertStack(lootResult, this.output);
        }
    }

    private int destroyBait() {
        for (int i : bait) {
            if (this.inventory[i] == null) continue;
            int quality = Fishing.fishing.getBaitQuality(this.inventory[i]);
            if (i <= 0 || !Fishing.fishing.canUseBait(this.inventory[4], this.inventory[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void updatePowerPerTick() {
        if (this.rf <= 300000) {
            double modifier = 1.0 - (double)this.rf / 300000.0 * 0.75;
            this.usage = (int)(modifier * (double)(20 + this.speed * 20));
        } else {
            this.usage = 1;
        }
    }

    @Override
    public boolean canWork() {
        return FeatureRedstone.RedstoneMode.canWork(this, this.mode) && this.hasRod() && this.getBait() > 0 && this.hasPower() && this.isFishable() && this.hasRoom(null);
    }

    private boolean hasRod() {
        if (this.inventory[4] != null) {
            RodType type = Fishing.fishing.getRodType(this.inventory[4]);
            return type != null ? type.canFish(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, null, this.inventory[4]) : false;
        }
        return false;
    }

    private int getBait() {
        for (int i : bait) {
            if (this.inventory[i] == null) continue;
            int quality = Fishing.fishing.getBaitQuality(this.inventory[i]);
            if (i <= 0 || !Fishing.fishing.canUseBait(this.inventory[4], this.inventory[i])) continue;
            return quality;
        }
        return 0;
    }

    private boolean hasPower() {
        return this.energyStorage.extractEnergy(this.getPowerPerTick(), true) >= this.getPowerPerTick();
    }

    private boolean isFishable() {
        return BlockHelper.isFishable(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
    }

    @Override
    public boolean isNotificationVisible(FeatureNotifications.NotificationType type) {
        switch (type) {
            case NO_ROD: {
                return !this.hasRod();
            }
            case NO_BAIT: {
                return this.hasRod() && this.getBait() <= 0;
            }
            case NOT_FISHABLE: {
                return !this.isFishable();
            }
            case NO_RF: {
                return !this.hasPower();
            }
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.baitChance = nbt.func_74762_e("BaitQuality");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("BaitQuality", this.baitChance);
    }
}

