/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.tile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.IIncubator;
import mariculture.core.Core;
import mariculture.core.config.Machines;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureNotifications;
import mariculture.core.lib.MachineSpeeds;
import mariculture.core.tile.base.TileMultiBlock;
import mariculture.core.tile.base.TileMultiMachinePowered;
import mariculture.core.util.IHasNotification;
import mariculture.fishery.items.ItemEgg;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileIncubator
extends TileMultiMachinePowered
implements IHasNotification,
IIncubator {
    private int cooldown = 0;
    private double mutation = 1.1;
    public int[] in = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12};

    public TileIncubator() {
        this.needsInit = true;
        this.max = MachineSpeeds.getIncubatorSpeed();
        this.inventory = new ItemStack[22];
        this.output = new int[]{13, 14, 15, 16, 17, 18, 19, 20, 21};
    }

    public void setMutationModifier(double d) {
        TileIncubator tile = (TileIncubator)this.getMaster();
        if (tile != null) {
            tile.cooldown = 25;
            tile.mutation = d;
        }
    }

    @Override
    public int getRFCapacity() {
        return 50000;
    }

    public int[] func_94128_d(int side) {
        return new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot > 3 && slot < 13 && (Fishing.fishHelper.isEgg(stack) || stack.func_77973_b() == Items.field_151110_aK || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150380_bt));
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot > 12;
    }

    @Override
    public boolean canWork() {
        return this.hasPower() && this.hasEgg() && this.rsAllowsWork() && this.outputHasRoom();
    }

    private boolean outputHasRoom() {
        if (this.setting.canEject(FeatureEject.EjectSetting.ITEM)) {
            return true;
        }
        int[] arr$ = this.output;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer i = arr$[i$];
            if (this.inventory[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateMasterMachine() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else {
                this.mutation = 1.0;
            }
            if (this.canWork) {
                this.energyStorage.extractEnergy(this.getPowerPerTick(), false);
                this.processed += this.speed;
                if (this.onTick(70)) {
                    this.processed -= this.heat;
                }
                if (this.processed >= this.max) {
                    this.processed = 0;
                    this.process();
                }
            } else {
                this.processed = 0;
            }
            if (this.processed <= 0) {
                this.processed = 0;
            }
        }
    }

    @Override
    public void process() {
        if (this.canWork()) {
            int loop = MaricultureHandlers.upgrades.hasUpgrade("incubator", this) ? 1024 : this.heat * 4 + 1;
            for (int o = 0; o < loop; ++o) {
                this.hatchEgg();
            }
        }
        this.updateCanWork();
    }

    private boolean hasEgg() {
        int[] arr$ = this.in;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer i = arr$[i$];
            if (this.inventory[i] == null) continue;
            return true;
        }
        return false;
    }

    private boolean hasPower() {
        return this.energyStorage.extractEnergy(this.getPowerPerTick() * 2, true) >= this.getPowerPerTick() * 2;
    }

    @Override
    public void updatePowerPerTick() {
        if (this.rf <= 300000) {
            double modifier = 1.0 - (double)this.rf / 300000.0 * 0.75;
            this.usage = (int)(modifier * (double)(36 + (this.speed - 1) * 40 + this.heat * 80));
        } else {
            this.usage = 1;
        }
    }

    public boolean hatchEgg() {
        Integer[] inArray = new Integer[this.in.length];
        int i = 0;
        for (int value : this.in) {
            inArray[i++] = value;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(inArray));
        Collections.shuffle(list);
        for (Integer j : list) {
            if (this.inventory[j] == null || !this.openEgg(j)) continue;
            return true;
        }
        return false;
    }

    private boolean openEgg(int slot) {
        if (MaricultureHandlers.upgrades.hasUpgrade("incubator", this)) {
            this.setMutationModifier(10000.0);
        } else if (MaricultureHandlers.upgrades.hasUpgrade("ethereal", this)) {
            this.setMutationModifier(1.35);
        }
        if (this.inventory[slot] == null) {
            return false;
        }
        Random rand = new Random();
        if (this.inventory[slot].func_77973_b() instanceof ItemEgg) {
            this.inventory[slot] = Fishing.fishHelper.attemptToHatchEgg(this.inventory[slot], rand, this.mutation, this);
        } else {
            if (this.inventory[slot].func_77973_b() == Items.field_151110_aK) {
                if (this.field_145850_b.field_73012_v.nextInt(8) == 0) {
                    this.helper.insertStack(new ItemStack(Items.field_151063_bx, 1, 93), this.output);
                }
                this.func_70298_a(slot, 1);
                return true;
            }
            if (this.inventory[slot].func_77973_b() == Item.func_150898_a((Block)Blocks.field_150380_bt)) {
                int chance;
                int n = chance = MaricultureHandlers.upgrades.hasUpgrade("ethereal", this) ? Machines.MachineSettings.DRAGON_EGG_ETHEREAL : Machines.MachineSettings.DRAGON_EGG_BASE;
                if (this.field_145850_b.field_73012_v.nextInt(chance) == 0) {
                    this.helper.insertStack(new ItemStack(Core.crafting, 1, 15), this.output);
                }
                if (this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                    this.func_70298_a(slot, 1);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getBirthChanceBoost() {
        return MaricultureHandlers.upgrades.getData("purity", this);
    }

    @Override
    public void eject(ItemStack fish) {
        this.helper.insertStack(fish, this.output);
    }

    @Override
    public boolean isNotificationVisible(FeatureNotifications.NotificationType type) {
        switch (type) {
            case NO_EGG: {
                return !this.hasEgg();
            }
            case NO_RF: {
                return !this.hasPower();
            }
        }
        return false;
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.ITEM;
    }

    @Override
    public void onBlockPlaced() {
        this.onBlockPlaced(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void onBlockPlaced(int x, int y, int z) {
        ArrayList<TileMultiBlock.MultiPart> parts;
        TileMultiBlock.MultiPart mstr;
        if (this.isBase(x, y, z) && this.isTop(x, y + 1, z) && this.isTop(x, y + 2, z) && !this.isTop(x, y + 3, z)) {
            mstr = new TileMultiBlock.MultiPart(x, y, z);
            parts = new ArrayList<TileMultiBlock.MultiPart>();
            parts.add(this.setAsSlave(mstr, x, y + 1, z, ForgeDirection.DOWN));
            parts.add(this.setAsSlave(mstr, x, y + 2, z));
            this.setAsMaster(mstr, parts);
        }
        if (this.isBase(x, y - 1, z) && this.isTop(x, y, z) && this.isTop(x, y + 1, z) && !this.isTop(x, y + 2, z)) {
            mstr = new TileMultiBlock.MultiPart(x, y - 1, z);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, x, y, z, ForgeDirection.DOWN));
            parts.add(this.setAsSlave(mstr, x, y + 1, z));
            this.setAsMaster(mstr, parts);
        }
        if (this.isBase(x, y - 2, z) && this.isTop(x, y - 1, z) && this.isTop(x, y, z) && !this.isTop(x, y + 1, z)) {
            mstr = new TileMultiBlock.MultiPart(x, y - 2, z);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, x, y - 1, z, ForgeDirection.DOWN));
            parts.add(this.setAsSlave(mstr, x, y, z));
            this.setAsMaster(mstr, parts);
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isBase(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == this.func_145838_q() && this.field_145850_b.func_72805_g(x, y, z) == 1;
    }

    public boolean isTop(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == this.func_145838_q() && this.field_145850_b.func_72805_g(x, y, z) == 2;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mutation = nbt.func_74769_h("MutationModifier");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("MutationModifier", this.mutation);
    }
}

