/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.tile;

import java.util.ArrayList;
import java.util.Random;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.RecipeSifter;
import mariculture.core.helpers.SpawnItemHelper;
import mariculture.core.helpers.cofh.InventoryHelper;
import mariculture.core.network.PacketCrack;
import mariculture.core.network.PacketHandler;
import mariculture.core.tile.base.TileMultiBlock;
import mariculture.core.tile.base.TileMultiStorage;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSifter
extends TileMultiStorage
implements ISidedInventory {
    public ItemStack texture = new ItemStack(Blocks.field_150344_f);
    public boolean hasInventory;
    private int[] slots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};

    public TileSifter() {
        this.inventory = new ItemStack[10];
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    public int[] func_94128_d(int side) {
        return this.slots;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        TileSifter master = this.getMaster();
        if (master != null) {
            return master.hasInventory && Fishing.sifter.getResult(stack) != null;
        }
        return false;
    }

    @Override
    public int func_70297_j_() {
        TileSifter master = this.getMaster();
        if (master != null) {
            return master.hasInventory ? super.func_70297_j_() : 0;
        }
        return 0;
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.length + 1;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        TileSifter master = this.getMaster();
        if (master != null) {
            return slot < 10 ? master.inventory[slot] : null;
        }
        return null;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return this.hasInventory;
    }

    public boolean process(ItemStack fullStack, Random rand) {
        ArrayList<RecipeSifter> result = Fishing.sifter.getResult(fullStack);
        if (result != null) {
            ItemStack display;
            Object object = display = fullStack.func_77973_b() instanceof ItemBlock ? fullStack : null;
            if (!this.field_145850_b.field_72995_K) {
                if (display == null) {
                    display = new ItemStack(Blocks.field_150346_d);
                }
                PacketHandler.sendAround(new PacketCrack(Block.func_149682_b((Block)Block.func_149634_a((Item)display.func_77973_b())), display.func_77960_j(), this.field_145851_c, this.field_145848_d, this.field_145849_e), this);
                PacketHandler.sendAround(new PacketCrack(Block.func_149682_b((Block)Block.func_149634_a((Item)display.func_77973_b())), display.func_77960_j(), ((TileMultiBlock.MultiPart)this.slaves.get((int)0)).xCoord, ((TileMultiBlock.MultiPart)this.slaves.get((int)0)).yCoord, ((TileMultiBlock.MultiPart)this.slaves.get((int)0)).zCoord), this);
            }
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "minecraft:step.grass", 1.0f, 1.0f);
            int loop = fullStack.field_77994_a;
            for (int i = 0; i < loop; ++i) {
                for (RecipeSifter bait : result) {
                    int chance = rand.nextInt(100);
                    if (chance >= bait.chance) continue;
                    ItemStack ret = bait.bait.func_77946_l();
                    ret.field_77994_a = bait.minCount + rand.nextInt(bait.maxCount + 1 - bait.minCount);
                    if (this.hasInventory) {
                        InventoryHelper.addItemStackToInventory(this.inventory, ret, this.slots);
                        continue;
                    }
                    if (this.field_145850_b.field_72995_K) continue;
                    if (rand.nextInt(2) == 0 && this.slaves.size() > 0) {
                        SpawnItemHelper.spawnItem(this.field_145850_b, ((TileMultiBlock.MultiPart)this.slaves.get((int)0)).xCoord, ((TileMultiBlock.MultiPart)this.slaves.get((int)0)).yCoord + 1, ((TileMultiBlock.MultiPart)this.slaves.get((int)0)).zCoord, ret.func_77946_l(), true, 0, 10, 0.25);
                        continue;
                    }
                    SpawnItemHelper.spawnItem(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, ret.func_77946_l(), true, 0, 10, 0.25);
                }
            }
            return true;
        }
        return false;
    }

    public int getSuitableSlot(ItemStack item) {
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) {
                return i;
            }
            if (this.inventory[i].func_77960_j() != item.func_77960_j() || this.inventory[i].func_77973_b() != item.func_77973_b() || this.inventory[i].field_77994_a + item.field_77994_a > this.inventory[i].func_77976_d()) continue;
            return i;
        }
        return 10;
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.hasInventory = nbt.func_74767_n("HasInventory");
        if (nbt.func_74764_b("Texture")) {
            this.texture = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbt.func_74781_a("Texture")));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("HasInventory", this.hasInventory);
        nbt.func_74782_a("Texture", (NBTBase)this.texture.func_77955_b(new NBTTagCompound()));
    }

    public boolean isSifter(int x, int y, int z) {
        return this.field_145850_b.func_147438_o(x, y, z) instanceof TileSifter && !this.isPartnered(x, y, z);
    }

    @Override
    public TileSifter getMaster() {
        if (this.master == null) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_147438_o(this.master.xCoord, this.master.yCoord, this.master.zCoord);
        return tile != null && tile instanceof TileSifter ? (TileSifter)tile : null;
    }

    @Override
    public void onBlockPlaced() {
        TileSifter master;
        if (this.onBlockPlaced(this.field_145851_c, this.field_145848_d, this.field_145849_e) && (master = this.getMaster()) != null && !master.isInit()) {
            master.init();
        }
    }

    public boolean onBlockPlaced(int x, int y, int z) {
        if (this.isSifter(x, y, z) && this.isSifter(x + 1, y, z)) {
            TileMultiBlock.MultiPart mstr = new TileMultiBlock.MultiPart(x, y, z);
            ArrayList<TileMultiBlock.MultiPart> parts = new ArrayList<TileMultiBlock.MultiPart>();
            parts.add(this.setAsSlave(mstr, x + 1, y, z, ForgeDirection.WEST));
            this.setAsMaster(mstr, parts, ForgeDirection.EAST);
            return true;
        }
        if (this.isSifter(x - 1, y, z) && this.isSifter(x, y, z)) {
            TileMultiBlock.MultiPart mstr = new TileMultiBlock.MultiPart(x - 1, y, z);
            ArrayList<TileMultiBlock.MultiPart> parts = new ArrayList<TileMultiBlock.MultiPart>();
            parts.add(this.setAsSlave(mstr, x, y, z, ForgeDirection.WEST));
            this.setAsMaster(mstr, parts, ForgeDirection.EAST);
            return true;
        }
        if (this.isSifter(x, y, z) && this.isSifter(x, y, z + 1)) {
            TileMultiBlock.MultiPart mstr = new TileMultiBlock.MultiPart(x, y, z);
            ArrayList<TileMultiBlock.MultiPart> parts = new ArrayList<TileMultiBlock.MultiPart>();
            parts.add(this.setAsSlave(mstr, x, y, z + 1, ForgeDirection.SOUTH));
            this.setAsMaster(mstr, parts, ForgeDirection.NORTH);
            return true;
        }
        if (this.isSifter(x, y, z - 1) && this.isSifter(x, y, z)) {
            TileMultiBlock.MultiPart mstr = new TileMultiBlock.MultiPart(x, y, z - 1);
            ArrayList<TileMultiBlock.MultiPart> parts = new ArrayList<TileMultiBlock.MultiPart>();
            parts.add(this.setAsSlave(mstr, x, y, z, ForgeDirection.SOUTH));
            this.setAsMaster(mstr, parts, ForgeDirection.NORTH);
            return true;
        }
        return false;
    }
}

