/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic;

import java.util.Map;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.MaricultureRegistry;
import mariculture.api.core.MaricultureTab;
import mariculture.core.config.Enchantments;
import mariculture.core.helpers.EnchantHelper;
import mariculture.core.helpers.RecipeHelper;
import mariculture.core.helpers.RegistryHelper;
import mariculture.core.lib.ItemLib;
import mariculture.core.lib.Modules;
import mariculture.magic.ItemMagicMirror;
import mariculture.magic.ItemMirror;
import mariculture.magic.ItemMobMagnet;
import mariculture.magic.JewelryHandler;
import mariculture.magic.MagicEventHandler;
import mariculture.magic.MirrorHandler;
import mariculture.magic.ShapedJewelryRecipe;
import mariculture.magic.ShapelessJewelryRecipe;
import mariculture.magic.enchantments.EnchantmentBlink;
import mariculture.magic.enchantments.EnchantmentElemental;
import mariculture.magic.enchantments.EnchantmentFallDamage;
import mariculture.magic.enchantments.EnchantmentFlight;
import mariculture.magic.enchantments.EnchantmentGlide;
import mariculture.magic.enchantments.EnchantmentHealth;
import mariculture.magic.enchantments.EnchantmentJump;
import mariculture.magic.enchantments.EnchantmentNeverHungry;
import mariculture.magic.enchantments.EnchantmentOneRing;
import mariculture.magic.enchantments.EnchantmentRestore;
import mariculture.magic.enchantments.EnchantmentResurrection;
import mariculture.magic.enchantments.EnchantmentSpeed;
import mariculture.magic.enchantments.EnchantmentSpider;
import mariculture.magic.enchantments.EnchantmentStepUp;
import mariculture.magic.jewelry.ItemBracelet;
import mariculture.magic.jewelry.ItemJewelry;
import mariculture.magic.jewelry.ItemNecklace;
import mariculture.magic.jewelry.ItemRing;
import mariculture.magic.jewelry.parts.BindingBasic;
import mariculture.magic.jewelry.parts.BindingDummy;
import mariculture.magic.jewelry.parts.BindingGold;
import mariculture.magic.jewelry.parts.JewelryBinding;
import mariculture.magic.jewelry.parts.JewelryMaterial;
import mariculture.magic.jewelry.parts.MaterialDummy;
import mariculture.magic.jewelry.parts.MaterialPearlBlack;
import mariculture.magic.jewelry.parts.MaterialPearlBlue;
import mariculture.magic.jewelry.parts.MaterialPearlBrown;
import mariculture.magic.jewelry.parts.MaterialPearlGold;
import mariculture.magic.jewelry.parts.MaterialPearlGreen;
import mariculture.magic.jewelry.parts.MaterialPearlOrange;
import mariculture.magic.jewelry.parts.MaterialPearlPink;
import mariculture.magic.jewelry.parts.MaterialPearlPurple;
import mariculture.magic.jewelry.parts.MaterialPearlRed;
import mariculture.magic.jewelry.parts.MaterialPearlSilver;
import mariculture.magic.jewelry.parts.MaterialPearlWhite;
import mariculture.magic.jewelry.parts.MaterialPearlYellow;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.RecipeSorter;

public class Magic
extends Modules.RegistrationModule {
    public static JewelryMaterial dummyMaterial;
    public static JewelryMaterial pearlBlack;
    public static JewelryMaterial pearlBlue;
    public static JewelryMaterial pearlBrown;
    public static JewelryMaterial pearlGold;
    public static JewelryMaterial pearlGreen;
    public static JewelryMaterial pearlOrange;
    public static JewelryMaterial pearlPink;
    public static JewelryMaterial pearlPurple;
    public static JewelryMaterial pearlRed;
    public static JewelryMaterial pearlSilver;
    public static JewelryMaterial pearlWhite;
    public static JewelryMaterial pearlYellow;
    public static JewelryBinding bindingGold;
    public static JewelryBinding bindingBasic;
    public static JewelryBinding dummyBinding;
    public static Enchantment elemental;
    public static Enchantment spider;
    public static Enchantment blink;
    public static Enchantment fall;
    public static Enchantment flight;
    public static Enchantment glide;
    public static Enchantment health;
    public static Enchantment jump;
    public static Enchantment hungry;
    public static Enchantment oneRing;
    public static Enchantment repair;
    public static Enchantment resurrection;
    public static Enchantment speed;
    public static Enchantment stepUp;
    public static Item basicMirror;
    public static Item magicMirror;
    public static Item celestialMirror;
    public static Item ring;
    public static Item bracelet;
    public static Item necklace;
    public static Item magnet;

    @Override
    public void registerHandlers() {
        MaricultureHandlers.mirror = new MirrorHandler();
        MinecraftForge.EVENT_BUS.register((Object)new MagicEventHandler());
    }

    @Override
    public void registerBlocks() {
    }

    @Override
    public void registerItems() {
        basicMirror = new ItemMirror("mirror").func_77655_b("mirror.basic");
        magicMirror = new ItemMagicMirror(1, 30, "magicMirror", 15, 1000).func_77655_b("mirror.magic");
        celestialMirror = new ItemMagicMirror(31, 60, "celestialMirror", 20, 10000).func_77655_b("mirror.celestial");
        ring = new ItemRing().func_77655_b("ring");
        bracelet = new ItemBracelet().func_77655_b("bracelet");
        necklace = new ItemNecklace().func_77655_b("necklace");
        magnet = new ItemMobMagnet(100).func_77655_b("mobmagnet");
        RegistryHelper.registerItems(new Item[]{basicMirror, magicMirror, celestialMirror, ring, bracelet, necklace, magnet});
    }

    @Override
    public void registerOther() {
        RecipeSorter.register((String)"mariculture:jewelryshaped", ShapedJewelryRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped before:minecraft:shapeless");
        RecipeSorter.register((String)"mariculture:jewelryshapeless", ShapelessJewelryRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        this.registerJewelry();
        this.registerEnchants();
        if (MaricultureTab.tabMagic != null) {
            MaricultureTab.tabMagic.setIcon(new ItemStack(basicMirror), false);
        }
    }

    private void registerJewelry() {
        dummyBinding = new BindingDummy();
        dummyMaterial = new MaterialDummy();
        pearlBlack = new MaterialPearlBlack();
        pearlBlue = new MaterialPearlBlue();
        pearlBrown = new MaterialPearlBrown();
        pearlGold = new MaterialPearlGold();
        pearlGreen = new MaterialPearlGreen();
        pearlOrange = new MaterialPearlOrange();
        pearlPink = new MaterialPearlPink();
        pearlPurple = new MaterialPearlPurple();
        pearlRed = new MaterialPearlRed();
        pearlSilver = new MaterialPearlSilver();
        pearlWhite = new MaterialPearlWhite();
        pearlYellow = new MaterialPearlYellow();
        bindingBasic = new BindingBasic();
        bindingGold = new BindingGold();
    }

    private void registerEnchants() {
        if (Enchantments.EnchantIds.spider > 0) {
            spider = new EnchantmentSpider(Enchantments.EnchantIds.spider, 3, EnumEnchantmentType.all);
        }
        if (Enchantments.EnchantIds.blink > 0) {
            blink = new EnchantmentBlink(Enchantments.EnchantIds.blink, 5, EnumEnchantmentType.all);
        }
        if (Enchantments.EnchantIds.fall > 0) {
            fall = new EnchantmentFallDamage(Enchantments.EnchantIds.fall, 5, EnumEnchantmentType.all);
        }
        if (Enchantments.EnchantIds.flight > 0) {
            flight = new EnchantmentFlight(Enchantments.EnchantIds.flight, 1, EnumEnchantmentType.all);
        }
        if (Enchantments.EnchantIds.glide > 0) {
            glide = new EnchantmentGlide(Enchantments.EnchantIds.glide, 1, EnumEnchantmentType.all);
        }
        if (Enchantments.EnchantIds.health > 0) {
            health = new EnchantmentHealth(Enchantments.EnchantIds.health, 4, EnumEnchantmentType.all);
        }
        if (Enchantments.EnchantIds.jump > 0) {
            jump = new EnchantmentJump(Enchantments.EnchantIds.jump, 6, EnumEnchantmentType.all);
        }
        if (Enchantments.EnchantIds.hungry > 0) {
            hungry = new EnchantmentNeverHungry(Enchantments.EnchantIds.hungry, 2, EnumEnchantmentType.all);
        }
        if (Enchantments.EnchantIds.oneRing > 0) {
            oneRing = new EnchantmentOneRing(Enchantments.EnchantIds.oneRing, 0, EnumEnchantmentType.all);
        }
        if (Enchantments.EnchantIds.repair > 0) {
            repair = new EnchantmentRestore(Enchantments.EnchantIds.repair, 3, EnumEnchantmentType.all);
        }
        if (Enchantments.EnchantIds.resurrection > 0) {
            resurrection = new EnchantmentResurrection(Enchantments.EnchantIds.resurrection, 1, EnumEnchantmentType.all);
        }
        if (Enchantments.EnchantIds.speed > 0) {
            speed = new EnchantmentSpeed(Enchantments.EnchantIds.speed, 6, EnumEnchantmentType.all);
        }
        if (Enchantments.EnchantIds.stepUp > 0) {
            stepUp = new EnchantmentStepUp(Enchantments.EnchantIds.stepUp, 5, EnumEnchantmentType.all);
        }
        if (Enchantments.EnchantIds.elemental > 0) {
            elemental = new EnchantmentElemental(Enchantments.EnchantIds.elemental, 4, EnumEnchantmentType.all);
        }
    }

    @Override
    public void registerRecipes() {
        RecipeHelper.addShaped(RecipeHelper._(magnet), new Object[]{"III", "I I", "M M", Character.valueOf('I'), "ingotIron", Character.valueOf('M'), ItemLib.enderPearl});
        RecipeHelper.addShaped(RecipeHelper._(basicMirror), new Object[]{" AA", "APA", "SA ", Character.valueOf('A'), "ingotAluminum", Character.valueOf('P'), Blocks.field_150410_aZ, Character.valueOf('S'), "ingotIron"});
        RecipeHelper.addShaped(RecipeHelper._(magicMirror), new Object[]{"PMP", "BEB", "PBP", Character.valueOf('B'), ItemLib.storageBookshelf, Character.valueOf('M'), basicMirror, Character.valueOf('E'), ItemLib.enchant, Character.valueOf('P'), ItemLib.pearls});
        RecipeHelper.addShaped(RecipeHelper._(celestialMirror), new Object[]{"TST", "BMB", "GBG", Character.valueOf('B'), ItemLib.storageBookshelf, Character.valueOf('M'), magicMirror, Character.valueOf('S'), ItemLib.netherStar, Character.valueOf('T'), ItemLib.magicDrop, Character.valueOf('G'), ItemLib.goldThread});
        this.addJewelry((ItemJewelry)ring);
        this.addJewelry((ItemJewelry)bracelet);
        this.addJewelry((ItemJewelry)necklace);
        this.addDungeonChestLoot();
    }

    private void addJewelry(ItemJewelry item) {
        ItemJewelry.JewelryType type = item.getType();
        for (Map.Entry<String, JewelryBinding> binding : JewelryBinding.list.entrySet()) {
            if (binding.getValue().ignore) continue;
            for (Map.Entry<String, JewelryMaterial> material : JewelryMaterial.list.entrySet()) {
                if (material.getValue().ignore) continue;
                JewelryBinding bind = binding.getValue();
                JewelryMaterial mat = material.getValue();
                ItemStack worked = JewelryHandler.createJewelry(item, bind, mat);
                JewelryHandler.addJewelry(type, worked, bind.getCraftingItem(type), mat.getCraftingItem(type), (int)((float)bind.getHitsBase(type) * mat.getHitsModifier(type)));
            }
        }
    }

    private void addDungeonChestLoot() {
        ItemStack oneRing;
        if (EnchantHelper.exists(Magic.oneRing) && (oneRing = MaricultureRegistry.get("ring.oneRing")) != null) {
            ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(oneRing, 1, 1, 1));
        }
    }
}

