/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import mariculture.core.helpers.EnchantHelper;
import mariculture.core.helpers.PlayerHelper;
import mariculture.core.helpers.cofh.ItemHelper;
import mariculture.magic.JewelryHandler;
import mariculture.magic.Magic;
import mariculture.magic.enchantments.EnchantmentBlink;
import mariculture.magic.enchantments.EnchantmentElemental;
import mariculture.magic.enchantments.EnchantmentFallDamage;
import mariculture.magic.enchantments.EnchantmentFlight;
import mariculture.magic.enchantments.EnchantmentGlide;
import mariculture.magic.enchantments.EnchantmentHealth;
import mariculture.magic.enchantments.EnchantmentJump;
import mariculture.magic.enchantments.EnchantmentNeverHungry;
import mariculture.magic.enchantments.EnchantmentOneRing;
import mariculture.magic.enchantments.EnchantmentRestore;
import mariculture.magic.enchantments.EnchantmentResurrection;
import mariculture.magic.enchantments.EnchantmentSpeed;
import mariculture.magic.enchantments.EnchantmentSpider;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class MagicEventHandler {
    private Random rand = new Random();

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.left;
        ItemStack right = event.right;
        if (!JewelryHandler.canApply(left) || !JewelryHandler.canApply(right)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer && !PlayerHelper.isFake((EntityPlayer)event.entity)) {
            World world = event.entity.field_70170_p;
            EntityPlayer player = (EntityPlayer)event.entity;
            if (world.field_72995_K) {
                if (EnchantHelper.exists(Magic.glide)) {
                    EnchantmentGlide.activate(player);
                }
                if (EnchantHelper.exists(Magic.speed)) {
                    EnchantmentSpeed.activate(player);
                }
                if (EnchantHelper.exists(Magic.spider)) {
                    EnchantmentSpider.activate(player);
                }
                if (EnchantHelper.exists(Magic.flight)) {
                    EnchantmentFlight.damage(player);
                }
            } else {
                if (EnchantHelper.exists(Magic.oneRing)) {
                    EnchantmentOneRing.activate(player);
                }
                if (EnchantHelper.exists(Magic.hungry)) {
                    EnchantmentNeverHungry.activate(player);
                }
            }
            if (!player.field_71075_bZ.field_75098_d && EnchantHelper.hasEnchantment(Magic.repair, player)) {
                EnchantmentRestore.activate(player);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        if (EnchantHelper.exists(Magic.jump) && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (player.field_70170_p.field_72995_K) {
                EnchantmentJump.activate(player);
            }
        }
    }

    @SubscribeEvent
    public void onEntityFall(LivingFallEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer && (EnchantHelper.exists(Magic.glide) || EnchantHelper.exists(Magic.fall) || EnchantHelper.exists(Magic.flight))) {
            EntityPlayer player = (EntityPlayer)event.entity;
            EnchantmentGlide.damage(player, this.rand);
            EnchantmentFallDamage.activate(event, player);
            if (EnchantHelper.hasEnchantment(Magic.flight, player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester == null) {
            return;
        }
        if (event.harvester.field_70170_p.field_72995_K) {
            return;
        }
        if (EnchantHelper.exists(Magic.elemental)) {
            EnchantmentElemental.onBlockBreak(event, event.harvester);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (EnchantHelper.exists(Magic.health) && event.entity instanceof EntityPlayer) {
            EnchantmentHealth.activate(event, (EntityPlayer)event.entity);
        }
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (EnchantHelper.exists(Magic.elemental) && event.entity instanceof EntityPlayer) {
            EnchantmentElemental.onHurt(event, (EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onAttackLiving(LivingAttackEvent event) {
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (EnchantHelper.exists(Magic.elemental)) {
            if (event.entity instanceof EntityPlayer) {
                EnchantmentElemental.onAttacked(event, (EntityPlayer)event.entity);
            }
            if (event.source.func_76364_f() instanceof EntityPlayer) {
                EnchantmentElemental.onAttack(event, (EntityPlayer)event.source.func_76364_f());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (EnchantHelper.hasEnchantment(Magic.blink, event.entityPlayer) && event.entityPlayer.field_70170_p.field_72995_K && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
            EnchantmentBlink.sendPacket((EntityClientPlayerMP)event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (EnchantHelper.exists(Magic.resurrection)) {
            EnchantmentResurrection.activate(event);
        }
        if (event.source.func_76364_f() != null && event.source.func_76364_f() instanceof EntityPlayer) {
            ItemStack magnet;
            EntityLivingBase entity = event.entityLiving;
            EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
            if (!(entity instanceof EntityPlayer) && ItemHelper.isPlayerHoldingItem(Magic.magnet, player) && !(magnet = player.func_71045_bC()).func_77942_o()) {
                magnet.func_77982_d(new NBTTagCompound());
                magnet.field_77990_d.func_74778_a("MobName", EntityList.func_75621_b((Entity)entity));
            }
        }
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (EnchantHelper.exists(Magic.elemental) && event.source.func_76364_f() instanceof EntityPlayer) {
            EnchantmentElemental.onKillEntity(event, (EntityPlayer)event.source.func_76364_f());
        }
    }
}

