/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic.enchantments;

import mariculture.api.core.MaricultureHandlers;
import mariculture.core.helpers.EnchantHelper;
import mariculture.magic.Magic;
import mariculture.magic.MirrorHelper;
import mariculture.magic.enchantments.EnchantmentJewelry;
import mariculture.magic.jewelry.parts.JewelryMaterial;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;

public class EnchantmentElemental
extends EnchantmentJewelry {
    public EnchantmentElemental(int i, int weight, EnumEnchantmentType type) {
        super(i, weight, type);
        this.func_77322_b("elemental");
        this.minLevel = 35;
        this.maxLevel = 50;
    }

    public int func_77325_b() {
        return 1;
    }

    public static void onHurt(LivingHurtEvent event, EntityPlayer player) {
        if (EnchantHelper.hasEnchantment(Magic.elemental, player)) {
            for (JewelryMaterial material : MirrorHelper.getMaterials(player)) {
                int onHurt = material.onHurt(event, player);
                if (onHurt <= 0 || player.field_70170_p.field_73012_v.nextInt(onHurt) != 0) continue;
                MaricultureHandlers.mirror.damageItemsWithEnchantment(player, Magic.elemental.field_77352_x, material.id);
            }
        }
    }

    public static void onAttacked(LivingAttackEvent event, EntityPlayer player) {
        if (EnchantHelper.hasEnchantment(Magic.elemental, player)) {
            for (JewelryMaterial material : MirrorHelper.getMaterials(player)) {
                int onAttacked = material.onAttacked(event, player);
                if (onAttacked <= 0 || player.field_70170_p.field_73012_v.nextInt(onAttacked) != 0) continue;
                MaricultureHandlers.mirror.damageItemsWithEnchantment(player, Magic.elemental.field_77352_x, material.id);
            }
        }
    }

    public static void onAttack(LivingAttackEvent event, EntityPlayer player) {
        if (EnchantHelper.hasEnchantment(Magic.elemental, player)) {
            for (JewelryMaterial material : MirrorHelper.getMaterials(player)) {
                int onAttack = material.onAttack(event, player);
                if (onAttack <= 0 || player.field_70170_p.field_73012_v.nextInt(onAttack) != 0) continue;
                MaricultureHandlers.mirror.damageItemsWithEnchantment(player, Magic.elemental.field_77352_x, material.id);
            }
        }
    }

    public static void onKillEntity(LivingDeathEvent event, EntityPlayer player) {
        if (EnchantHelper.hasEnchantment(Magic.elemental, player)) {
            for (JewelryMaterial material : MirrorHelper.getMaterials(player)) {
                int onKill = material.onKill(event, player);
                if (onKill <= 0 || player.field_70170_p.field_73012_v.nextInt(onKill) != 0) continue;
                MaricultureHandlers.mirror.damageItemsWithEnchantment(player, Magic.elemental.field_77352_x, material.id);
            }
        }
    }

    public static void onBlockBreak(BlockEvent.HarvestDropsEvent event, EntityPlayer player) {
        if (EnchantHelper.hasEnchantment(Magic.elemental, player)) {
            for (JewelryMaterial material : MirrorHelper.getMaterials(player)) {
                int onBlockBreak = material.onBlockBreak(event, player);
                if (onBlockBreak <= 0 || player.field_70170_p.field_73012_v.nextInt(onBlockBreak) != 0) continue;
                MaricultureHandlers.mirror.damageItemsWithEnchantment(player, Magic.elemental.field_77352_x, material.id);
            }
        }
    }
}

