/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.Core;
import mariculture.core.helpers.RecipeHelper;
import mariculture.core.lib.Modules;
import mariculture.plugins.Plugins;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import rebelkeithy.mods.aquaculture.items.AquacultureItems;
import rebelkeithy.mods.aquaculture.items.ItemFish;

public class PluginAquaculture
extends Plugins.Plugin {
    public PluginAquaculture(String name) {
        super(name);
    }

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        if (Modules.isActive(Modules.fishery)) {
            Fishing.fishing.addBait(new ItemStack((Item)AquacultureItems.fish, 1, 19), 25);
            Fishing.fishing.addBaitForQuality(new ItemStack((Item)AquacultureItems.fish, 1, 19), Arrays.asList(RodType.DIRE, RodType.FLUX));
        }
    }

    @Override
    public void postInit() {
        if (Modules.isActive(Modules.fishery)) {
            Iterator iterator = CraftingManager.func_77594_a().func_77592_b().iterator();
            while (iterator.hasNext()) {
                IRecipe recipe = (IRecipe)iterator.next();
                if (recipe.func_77571_b() == null || recipe.func_77571_b().func_77973_b() != AquacultureItems.metaLootItem || recipe.func_77571_b().func_77960_j() != 3) continue;
                iterator.remove();
            }
            for (Map.Entry<Integer, FishSpecies> list : FishSpecies.species.entrySet()) {
                FishSpecies species = list.getValue();
                if (species.getFishMealSize() <= 0) continue;
                RecipeHelper.addShapeless(new ItemStack(this.getItem("item.loot"), species.getFishMealSize(), 3), new Object[]{species.getRawForm(1), "foodSalt"});
            }
            for (int i = 0; i < AquacultureItems.fish.fish.size(); ++i) {
                ItemFish.Fish f = (ItemFish.Fish)AquacultureItems.fish.fish.get(i);
                if (f.filletAmount == 0) continue;
                int amount = f.filletAmount;
                ItemStack raw = new ItemStack((Item)AquacultureItems.fish, 1, i);
                RecipeHelper.addShapeless(AquacultureItems.fishFillet.getItemStack(amount), new Object[]{raw, "foodSalt"});
                RecipeHelper.addShapeless(new ItemStack(Core.materials, amount, 14), new Object[]{raw});
                OreDictionary.registerOre((String)"fish", (ItemStack)raw);
                RecipeHelper.addFishSushi(raw, amount);
                RecipeHelper.addFishSoup(raw, amount);
                RecipeHelper.addFishMeal(raw, amount);
                RecipeHelper.addFishMelting(raw, amount * 500, new ItemStack(Items.field_151103_aS), 10);
            }
        }
    }
}

