/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins;

import biomesoplenty.api.content.BOPCBiomes;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.handlers.LogHandler;
import mariculture.core.handlers.OreDicHandler;
import mariculture.core.helpers.RecipeHelper;
import mariculture.core.lib.Extra;
import mariculture.core.lib.ItemLib;
import mariculture.plugins.Plugins;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.logging.log4j.Level;

public class PluginBiomesOPlenty
extends Plugins.Plugin {
    public PluginBiomesOPlenty(String name) {
        super(name);
    }

    private void addBiome(BiomeGenBase biome, int temp, Environment.Salinity salt) {
        if (biome != null) {
            MaricultureHandlers.environment.addEnvironment(biome, salt, temp);
        }
    }

    @Override
    public void preInit() {
        Extra.HAS_BOP = Loader.isModLoaded((String)"BiomesOPlenty");
        OreDicHandler.registerWildcard(new ItemStack(GameRegistry.findBlock((String)"BiomesOPlenty", (String)"planks")), new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14});
        OreDicHandler.registerWildcard(new ItemStack(GameRegistry.findBlock((String)"BiomesOPlenty", (String)"saplings")), new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15});
        OreDicHandler.registerWildcard(new ItemStack(GameRegistry.findBlock((String)"BiomesOPlenty", (String)"colorizedSaplings")), new Integer[]{0, 1, 2, 3, 4, 5, 6});
        OreDicHandler.registerWildcard(new ItemStack(GameRegistry.findBlock((String)"BiomesOPlenty", (String)"woodenSingleSlab1")), new Integer[]{0, 1, 2, 3, 4, 5, 6, 7});
        OreDicHandler.registerWildcard(new ItemStack(GameRegistry.findBlock((String)"BiomesOPlenty", (String)"woodenSingleSlab2")), new Integer[]{0, 1, 2, 3, 4});
        OreDicHandler.registerWildcard(new ItemStack(GameRegistry.findBlock((String)"BiomesOPlenty", (String)"colorizedLeaves1")), new Integer[]{0, 1, 2, 3});
        OreDicHandler.registerWildcard(new ItemStack(GameRegistry.findBlock((String)"BiomesOPlenty", (String)"colorizedLeaves2")), new Integer[]{0, 1, 2});
        OreDicHandler.registerWildcard(new ItemStack(GameRegistry.findBlock((String)"BiomesOPlenty", (String)"leaves1")), new Integer[]{0, 1, 2, 3});
        OreDicHandler.registerWildcard(new ItemStack(GameRegistry.findBlock((String)"BiomesOPlenty", (String)"leaves2")), new Integer[]{0, 1, 2, 3});
        OreDicHandler.registerWildcard(new ItemStack(GameRegistry.findBlock((String)"BiomesOPlenty", (String)"leaves3")), new Integer[]{0, 1, 2, 3});
        OreDicHandler.registerWildcard(new ItemStack(GameRegistry.findBlock((String)"BiomesOPlenty", (String)"leaves4")), new Integer[]{0, 1});
        OreDicHandler.registerWildcard(new ItemStack(GameRegistry.findBlock((String)"BiomesOPlenty", (String)"appleLeaves")), new Integer[]{0});
        OreDicHandler.registerWildcard(new ItemStack(GameRegistry.findBlock((String)"BiomesOPlenty", (String)"persimmonLeaves")), new Integer[]{0});
    }

    private static BiomeGenBase getBiome(String str) {
        try {
            Field field = BOPCBiomes.class.getField(str);
            return (BiomeGenBase)field.get(null);
        }
        catch (Exception e) {
            LogHandler.log(Level.INFO, "Couldn't find the BiomesOPlenty Biome " + str + " : This is NOT an issue, do not report!");
            return null;
        }
    }

    @Override
    public void init() {
        boolean found = true;
        try {
            Class.forName("biomesoplenty.api.content.BOPCBiomes");
        }
        catch (ClassNotFoundException e) {
            found = false;
        }
        if (found) {
            this.addBiome(PluginBiomesOPlenty.getBiome("alps"), -5, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("alpsForest"), -1, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("arctic"), -1, Environment.Salinity.SALINE);
            this.addBiome(PluginBiomesOPlenty.getBiome("bambooForest"), 20, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("bayou"), 15, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("bog"), 7, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("borealForest"), 11, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("brushland"), 30, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("canyon"), 40, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("chaparral"), 6, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("cherryBlossomGrove"), 12, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("coniferousForest"), 5, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("snowyConiferousForest"), 2, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("crag"), 40, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("deadForest"), 40, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("deadSwamp"), 7, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("deciduousForest"), 8, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("dunes"), 50, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("fen"), 12, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("flowerField"), 11, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("frostForest"), 3, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("fungiForest"), 6, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("grassland"), 10, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("grove"), 10, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("heathland"), 7, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("highland"), 6, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("jadeCliffs"), 13, Environment.Salinity.BRACKISH);
            this.addBiome(PluginBiomesOPlenty.getBiome("lavenderFields"), 10, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("lushDesert"), 37, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("lushSwamp"), 8, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("mapleWoods"), 12, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("marsh"), 7, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("meadow"), 10, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("moor"), 3, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("mountain"), 0, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("mysticGrove"), 10, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("ominousWoods"), 8, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("originValley"), 11, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("outback"), 24, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("prairie"), 20, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("rainforest"), 25, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("redwoodForest"), 5, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("sacredSprings"), 14, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("seasonalForest"), 10, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("shield"), 8, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("shrubland"), 17, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("silkglades"), 20, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("sludgepit"), 15, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("spruceWoods"), 8, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("steppe"), 20, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("temperateRainforest"), 15, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("thicket"), 10, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("timber"), 7, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("tropicalRainforest"), 28, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("tundra"), 1, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("wasteland"), 40, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("wetland"), 8, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("woodland"), 10, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("glacier"), 0, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("scrubland"), 32, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("oasis"), 22, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("quagmire"), 9, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("tropics"), 27, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("volcano"), 75, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("meadowForest"), 9, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("alpsForest"), -1, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("kelpForest"), 24, Environment.Salinity.SALINE);
            this.addBiome(PluginBiomesOPlenty.getBiome("corruptedSands"), 90, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("undergarden"), 78, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("phantasmagoricInferno"), 100, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("boneyard"), 79, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("visceralHeap"), 80, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("lushRiver"), 8, Environment.Salinity.FRESH);
            this.addBiome(PluginBiomesOPlenty.getBiome("dryRiver"), 37, Environment.Salinity.FRESH);
        }
        Item flowers = GameRegistry.findItem((String)"BiomesOPlenty", (String)"flowers");
        Item flower2 = GameRegistry.findItem((String)"BiomesOPlenty", (String)"flowers2");
        Item mushroom = GameRegistry.findItem((String)"BiomesOPlenty", (String)"mushrooms");
        RecipeHelper.addCrushRecipe(RecipeHelper._(ItemLib.cyanDye, 2), new ItemStack(flowers, 1, 1), true);
        RecipeHelper.addCrushRecipe(RecipeHelper._(ItemLib.purpleDye, 2), new ItemStack(flowers, 1, 8), true);
        RecipeHelper.addCrushRecipe(RecipeHelper._(ItemLib.purpleDye, 2), new ItemStack(flower2, 1, 3), true);
        RecipeHelper.addCrushRecipe(RecipeHelper._(ItemLib.lightGreyDye, 2), new ItemStack(flowers, 1, 15), true);
        RecipeHelper.addCrushRecipe(RecipeHelper._(ItemLib.pinkDye, 2), new ItemStack(flowers, 1, 6), true);
        RecipeHelper.addCrushRecipe(RecipeHelper._(ItemLib.pinkDye, 2), new ItemStack(flower2, 1, 0), true);
        RecipeHelper.addCrushRecipe(RecipeHelper._(ItemLib.limeDye, 2), new ItemStack(mushroom, 1, 3), true);
        RecipeHelper.addCrushRecipe(RecipeHelper._(ItemLib.dandelionDye, 2), new ItemStack(flower2, 1, 4), true);
        RecipeHelper.addCrushRecipe(RecipeHelper._(ItemLib.lightBlueDye, 2), new ItemStack(flowers, 1, 4), true);
        RecipeHelper.addCrushRecipe(RecipeHelper._(ItemLib.lightBlueDye, 2), new ItemStack(flower2, 1, 7), true);
        RecipeHelper.addCrushRecipe(RecipeHelper._(ItemLib.magentaDye, 2), new ItemStack(flowers, 1, 7), true);
        RecipeHelper.addCrushRecipe(RecipeHelper._(ItemLib.orangeDye, 2), new ItemStack(flowers, 1, 5), true);
        RecipeHelper.addCrushRecipe(RecipeHelper._(ItemLib.orangeDye, 2), new ItemStack(flower2, 1, 2), true);
    }

    @Override
    public void postInit() {
    }

    public static enum Biome {
        KELP,
        CORAL;

    }
}

