/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins;

import highlands.api.HighlandsBiomes;
import java.lang.reflect.Field;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.handlers.LogHandler;
import mariculture.plugins.Plugins;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.logging.log4j.Level;

public class PluginHighlands
extends Plugins.Plugin {
    public PluginHighlands(String name) {
        super(name);
    }

    private void addBiome(BiomeGenBase biome, int temp, Environment.Salinity salt) {
        if (biome != null) {
            MaricultureHandlers.environment.addEnvironment(biome, salt, temp);
        }
    }

    private static BiomeGenBase getBiome(String str) {
        try {
            Field field = HighlandsBiomes.class.getField(str);
            return (BiomeGenBase)field.get(null);
        }
        catch (Exception e) {
            LogHandler.log(Level.INFO, "Couldn't find the Highlands Biome " + str + " : This is NOT an issue, do not report!");
            return null;
        }
    }

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        boolean found = true;
        try {
            Class.forName("highlands.api.HighlandsBiomes");
        }
        catch (ClassNotFoundException e) {
            found = false;
        }
        if (found) {
            this.addBiome(PluginHighlands.getBiome("woodsMountains"), 12, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("highlandsb"), 6, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("tundra"), 1, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("cliffs"), 13, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("pinelands"), 6, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("autumnForest"), 8, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("alps"), 1, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("tallPineForest"), 5, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("meadow"), 10, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("savannah"), 28, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("tropics"), 27, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("outback"), 24, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("woodlands"), 11, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("bog"), 7, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("redwoodForest"), 6, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("dunes"), 50, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("lowlands"), 9, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("sahel"), 23, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("birchHills"), 9, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("tropicalIslands"), 26, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("rainforest"), 25, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("estuary"), 10, Environment.Salinity.BRACKISH);
            this.addBiome(PluginHighlands.getBiome("badlands"), 35, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("flyingMountains"), 8, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("snowMountains"), 2, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("rockMountains"), 3, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("desertMountains"), 40, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("steppe"), 20, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("glacier"), -1, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("ocean2"), 4, Environment.Salinity.SALINE);
            this.addBiome(PluginHighlands.getBiome("forestIsland"), 10, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("jungleIsland"), 25, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("desertIsland"), 35, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("volcanoIsland"), 30, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("snowIsland"), 3, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("windyIsland"), 8, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("valley"), 10, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("lake"), 10, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("mesa"), 36, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("baldHill"), 12, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("oasis"), 15, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("canyon"), 30, Environment.Salinity.FRESH);
            this.addBiome(PluginHighlands.getBiome("shrubland"), 25, Environment.Salinity.FRESH);
        }
    }
}

