/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins;

import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import mariculture.core.handlers.LogHandler;
import mariculture.core.lib.Modules;
import mariculture.plugins.PluginHelper;
import org.apache.logging.log4j.Level;

public class Plugins
extends Modules.Module {
    public static ArrayList<Plugin> plugins = new ArrayList();

    public Plugins() {
        this.add("HEE", "HardcoreEnderExpansion");
        this.add("Railcraft");
        this.add("TConstruct");
        this.add("Forestry");
        this.add("Thaumcraft");
        this.add("BiomesOPlenty");
        this.add("HungerOverhaul");
        this.add("Enchiridion");
        this.add("Highlands");
        this.add("BloodMagic", "AWWayofTime");
        this.add("LiquidXP");
        this.add("MineFactoryReloaded", "MFR");
        this.add("OpenBlocks");
        this.add("Waila");
        this.add("ThermalFoundation");
        this.add("RedstoneArsenal");
        this.add("Aquaculture");
        this.add("HarvestCraft", "harvestcraft");
        this.add("ModdedTweaks", "Enchiridion");
    }

    public void add(String str) {
        this.add(str, str);
    }

    public void add(String clazz, String mod) {
        if (Loader.isModLoaded((String)mod)) {
            try {
                Class.forName("mariculture.plugins.Plugin" + clazz).getConstructor(String.class).newInstance(mod);
            }
            catch (Exception e) {
                LogHandler.log(Level.WARN, "Something went wrong when initializing " + clazz + " Plugin");
            }
        }
    }

    @Override
    public void setLoaded(String str) {
        LogHandler.log(Level.INFO, str + " Plugin Finished Loading");
    }

    @Override
    public void preInit() {
        for (Plugin plug : plugins) {
            plug.load(Plugin.Stage.PRE);
        }
    }

    @Override
    public void init() {
        for (Plugin plug : plugins) {
            plug.load(Plugin.Stage.INIT);
        }
    }

    @Override
    public void postInit() {
        for (Plugin plug : plugins) {
            plug.load(Plugin.Stage.POST);
            this.setLoaded(plug.getClass().getSimpleName().substring(6));
        }
    }

    public static abstract class Plugin
    extends PluginHelper {
        public Plugin(String name) {
            super(name);
            plugins.add(this);
        }

        public void load(Stage stage) {
            try {
                switch (stage) {
                    case PRE: {
                        this.preInit();
                        break;
                    }
                    case INIT: {
                        this.init();
                        break;
                    }
                    case POST: {
                        this.postInit();
                    }
                }
            }
            catch (Exception e) {
                LogHandler.log(Level.WARN, "Something went wrong with " + this.name + " Plugin at " + stage.toString() + " Phase");
                e.printStackTrace();
            }
        }

        public abstract void preInit();

        public abstract void init();

        public abstract void postInit();

        public static enum Stage {
            PRE,
            INIT,
            POST;

        }
    }
}

