/*
 * Decompiled with CFR 0.152.
 */
package mariculture.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import mariculture.api.core.MaricultureTab;
import mariculture.core.Core;
import mariculture.core.blocks.base.BlockDecorative;
import mariculture.core.config.Gardening;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.util.IHasMeta;
import mariculture.world.WorldPlus;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockCoral
extends BlockDecorative
implements IPlantable,
IHasMeta {
    private static HashMap<String, Integer[]> outcomes = new HashMap();

    protected BlockCoral(boolean tick, String prefix) {
        super(Material.field_151586_h);
        float f = 0.375f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
        this.func_149675_a(tick);
        this.func_149647_a(MaricultureTab.tabCore);
        this.prefix = prefix;
    }

    @Override
    public String getToolType(int meta) {
        return null;
    }

    @Override
    public int getToolLevel(int meta) {
        return 0;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) <= 0 ? 0.05f : 1.0f;
    }

    @Override
    public Item func_149650_a(int i, Random rand, int j) {
        return Item.func_150898_a((Block)WorldPlus.plantStatic);
    }

    @Override
    public int func_149692_a(int dmg) {
        return dmg == 0 ? 1 : dmg;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        int metaDown;
        Block block = world.func_147439_a(x, y - 1, z);
        if (!BlockCoral.canSustainPlant(block, metaDown = world.func_72805_g(x, y - 1, z))) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147449_b(x, y, z, Blocks.field_150355_j);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int meta;
        Block block;
        if ((stack == null || stack.func_77960_j() <= 0) && BlockCoral.isKelpTop(block = world.func_147439_a(x, y - 1, z), meta = world.func_72805_g(x, y - 1, z))) {
            world.func_72921_c(x, y - 1, z, 0, 2);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (meta <= 0 && BlockCoral.isKelp(world.func_147439_a(x, y - 1, z), world.func_72805_g(x, y - 1, z))) {
            world.func_72921_c(x, y - 1, z, 1, 2);
        }
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 1;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Water;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z);
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public static boolean canSustainPlant(Block block, int meta) {
        return meta <= 0 ? BlockCoral.canSustainKelp(block, meta) : BlockCoral.canSustainCoral(block, meta);
    }

    public static boolean canSustainCoral(Block block, int meta) {
        return block == Core.sands || block == Core.limestone || block == Blocks.field_150354_m || block == Blocks.field_150347_e || block == Blocks.field_150341_Y || block == Core.rocks && meta == 0;
    }

    public static boolean canSustainKelp(Block block, int meta) {
        if (block == Blocks.field_150347_e || block == Blocks.field_150341_Y || block == Blocks.field_150354_m || block == Blocks.field_150351_n) {
            return true;
        }
        if (block == Core.rocks && meta == 0 || block == Core.limestone || block == Core.sands) {
            return true;
        }
        return BlockCoral.isKelp(block, meta);
    }

    private static boolean isPlant(Block block) {
        return block == WorldPlus.plantGrowable || block == WorldPlus.plantStatic;
    }

    private static boolean isKelp(Block block, int meta) {
        return BlockCoral.isPlant(block) && meta <= 0;
    }

    private static boolean isKelpTop(Block block, int meta) {
        return BlockCoral.isKelp(block, meta) && meta == 1;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            int meta = world.func_72805_g(x, y, z);
            if (Gardening.KELP_GROWTH_ENABLED && meta == 1) {
                this.updateKelp(world, x, y, z, rand);
            } else if (Gardening.CORAL_SPREAD_ENABLED && meta > 0) {
                this.updateCoral(world, x, y, z, rand);
            } else if (Gardening.MOSS_SPREAD_ENABLED && meta == 0) {
                this.updateMoss(world, x, y, z, rand);
            }
        }
    }

    private void updateKelp(World world, int x, int y, int z, Random rand) {
        if (rand.nextInt(Gardening.KELP_GROWTH_CHANCE) == 0 && BlockHelper.isWater(world, x, y + 2, z)) {
            world.func_147449_b(x, y + 1, z, (Block)this);
            this.func_149689_a(world, x, y, z, null, null);
        }
    }

    private void updateMoss(World world, int x, int y, int z, Random rand) {
        int randZ;
        int randX;
        Block block;
        if (rand.nextInt(Gardening.KELP_SPREAD_CHANCE) == 0 && ((block = world.func_147439_a(x, y - 1, z)) == Blocks.field_150341_Y || block == Blocks.field_150417_aV && world.func_72805_g(x, y - 1, z) == 1) && world.func_147439_a(randX = rand.nextInt(8) - 4, y + 1, randZ = rand.nextInt(8) - 4) == Blocks.field_150355_j) {
            Block theBlock = world.func_147439_a(randX, y - 1, randZ);
            if (theBlock == Blocks.field_150347_e) {
                world.func_147449_b(x, y - 1, z, Blocks.field_150341_Y);
            } else if (theBlock == Blocks.field_150417_aV && world.func_72805_g(x, y, z) != 1) {
                world.func_72921_c(x, y - 1, z, 1, 2);
            }
        }
    }

    private void updateCoral(World world, int x, int y, int z, Random rand) {
        int randZ;
        int randY;
        int randX;
        Block block;
        if (rand.nextInt(Gardening.CORAL_SPREAD_CHANCE) == 0 && (block = world.func_147439_a(x, y - 1, z)) == Core.rocks && world.func_72805_g(x, y - 1, z) == 0 && world.func_147439_a(randX = x + 1 + rand.nextInt(4) - 2 - rand.nextInt(2), randY = y + rand.nextInt(3) - 1, randZ = z + 1 + rand.nextInt(4) - 2 - rand.nextInt(2)) == WorldPlus.plantGrowable) {
            int thisMeta = world.func_72805_g(x, y, z);
            int thatMeta = world.func_72805_g(randX, randY, randZ);
            int newMeta = this.getNewColor(thisMeta, thatMeta, rand);
            randX = x + 1 + rand.nextInt(4) - 2 - rand.nextInt(2);
            if (world.func_147439_a(randX, randY = y + rand.nextInt(3) - 1, randZ = z + 1 + rand.nextInt(4) - 2 - rand.nextInt(2)) == Blocks.field_150355_j && world.func_147439_a(randX, randY + 1, randZ) == Blocks.field_150355_j && BlockCoral.canSustainCoral(world.func_147439_a(randX, randY - 1, randZ), world.func_72805_g(randX, randY - 1, randZ))) {
                world.func_147465_d(randX, randY, randZ, WorldPlus.plantGrowable, newMeta, 2);
            }
        }
    }

    private Integer getNewColor(int thisMeta, int thatMeta, Random rand) {
        Integer[] values = outcomes.get("" + thisMeta + "|" + thatMeta);
        if (values == null) {
            values = outcomes.get("" + thatMeta + "|" + thisMeta);
        }
        if (rand.nextInt(2) == 0) {
            return thisMeta;
        }
        if (rand.nextInt(2) == 0) {
            return thatMeta;
        }
        if (values != null) {
            return values[rand.nextInt(values.length)];
        }
        return rand.nextInt(2) == 0 ? thisMeta : thatMeta;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[this.getMetaCount()];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("mariculture:coral_" + this.getName(i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        if (creativeTabs == MaricultureTab.tabWorld) {
            for (int meta = 0; meta < 13; ++meta) {
                if (meta == 0) continue;
                list.add(new ItemStack(item, 1, meta));
            }
        }
    }

    @Override
    public int getMetaCount() {
        return 13;
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return null;
    }

    static {
        outcomes.put("3|12", new Integer[]{2, 7});
        outcomes.put("3|4", new Integer[]{9, 5});
        outcomes.put("3|7", new Integer[]{8, 6});
        outcomes.put("12|10", new Integer[]{11});
        outcomes.put("12|9", new Integer[]{4, 10, 11});
        outcomes.put("12|4", new Integer[]{10});
        outcomes.put("9|3", new Integer[]{5});
        outcomes.put("8|3", new Integer[]{7, 6});
        outcomes.put("8|10", new Integer[]{3});
        outcomes.put("8|4", new Integer[]{3});
        outcomes.put("7|10", new Integer[]{3});
        outcomes.put("7|11", new Integer[]{12});
    }
}

