/*
 * Decompiled with CFR 0.152.
 */
package mariculture.world;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import mariculture.api.core.MaricultureTab;
import mariculture.core.Core;
import mariculture.core.helpers.RecipeHelper;
import mariculture.core.helpers.RegistryHelper;
import mariculture.core.lib.Modules;
import mariculture.factory.Factory;
import mariculture.fishery.Fishery;
import mariculture.world.BlockCoral;
import mariculture.world.GenerationHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.oredict.OreDictionary;

public class WorldPlus
extends Modules.RegistrationModule {
    public static final String OCEAN_CHEST = "oceanFloorChest";
    public static Block plantGrowable;
    public static Block plantStatic;

    @Override
    public void registerHandlers() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GenerationHandler(), (int)2);
    }

    @Override
    public void registerBlocks() {
        plantGrowable = new BlockCoral(true, "plant_growable_").func_149672_a(Block.field_149779_h).func_149752_b(0.1f).func_149663_c("plant.growable");
        plantStatic = new BlockCoral(false, "plant_static_").func_149672_a(Block.field_149779_h).func_149752_b(0.1f).func_149663_c("plant.static");
        RegistryHelper.registerBlocks(new Block[]{plantGrowable, plantStatic});
    }

    @Override
    public void registerItems() {
    }

    @Override
    public void registerOther() {
        if (MaricultureTab.tabWorld != null) {
            MaricultureTab.tabWorld.setIcon(new ItemStack(plantStatic, 1, 7), false);
        }
        RegistryHelper.registerCoral(new ItemStack(plantStatic, 1, 4), "LightBlue");
        RegistryHelper.registerCoral(new ItemStack(plantStatic, 1, 7), "Yellow");
        RegistryHelper.registerCoral(new ItemStack(plantStatic, 1, 5), "Magenta");
        RegistryHelper.registerCoral(new ItemStack(plantStatic, 1, 6), "Brown");
        RegistryHelper.registerCoral(new ItemStack(plantStatic, 1, 8), "Orange");
        RegistryHelper.registerCoral(new ItemStack(plantStatic, 1, 2), "Pink");
        RegistryHelper.registerCoral(new ItemStack(plantStatic, 1, 9), "Purple");
        RegistryHelper.registerCoral(new ItemStack(plantStatic, 1, 3), "Red");
        OreDictionary.registerOre((String)"coralWhite", (ItemStack)new ItemStack(plantStatic, 1, 12));
        OreDictionary.registerOre((String)"coralGray", (ItemStack)new ItemStack(plantStatic, 1, 10));
        OreDictionary.registerOre((String)"coralLightGray", (ItemStack)new ItemStack(plantStatic, 1, 11));
        OreDictionary.registerOre((String)"plantKelp", (ItemStack)new ItemStack(plantStatic, 1, 1));
    }

    @Override
    public void registerRecipes() {
        RecipeHelper.addCrushRecipe(new ItemStack(Core.materials, 1, 32), "coralBrown", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Core.materials, 1, 31), "coralRed", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Core.materials, 1, 30), "coralYellow", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Items.field_151100_aR, 1, 12), "coralLightBlue", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Items.field_151100_aR, 1, 13), "coralMagenta", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Items.field_151100_aR, 1, 14), "coralOrange", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Items.field_151100_aR, 1, 9), "coralPink", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Items.field_151100_aR, 1, 5), "coralPurple", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Items.field_151100_aR, 1, 8), "coralGray", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Items.field_151100_aR, 1, 7), "coralLightGray", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Core.materials, 1, 27), "coralWhite", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Core.materials, 1, 29), "plantKelp", true);
        RecipeHelper.addBleachRecipe(new ItemStack(plantStatic, 1, 4), new ItemStack(plantStatic, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(plantStatic, 1, 7), new ItemStack(plantStatic, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(plantStatic, 1, 5), new ItemStack(plantStatic, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(plantStatic, 1, 6), new ItemStack(plantStatic, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(plantStatic, 1, 8), new ItemStack(plantStatic, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(plantStatic, 1, 2), new ItemStack(plantStatic, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(plantStatic, 1, 9), new ItemStack(plantStatic, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(plantStatic, 1, 3), new ItemStack(plantStatic, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(plantStatic, 1, 10), new ItemStack(plantStatic, 1, 11), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(plantStatic, 1, 11), new ItemStack(plantStatic, 1, 12), 5);
        RecipeHelper.addSoakRecipe(new ItemStack(plantStatic, 1, 4), new ItemStack(plantGrowable, 1, 4), 1);
        RecipeHelper.addSoakRecipe(new ItemStack(plantStatic, 1, 7), new ItemStack(plantGrowable, 1, 7), 1);
        RecipeHelper.addSoakRecipe(new ItemStack(plantStatic, 1, 5), new ItemStack(plantGrowable, 1, 5), 1);
        RecipeHelper.addSoakRecipe(new ItemStack(plantStatic, 1, 6), new ItemStack(plantGrowable, 1, 6), 1);
        RecipeHelper.addSoakRecipe(new ItemStack(plantStatic, 1, 8), new ItemStack(plantGrowable, 1, 8), 1);
        RecipeHelper.addSoakRecipe(new ItemStack(plantStatic, 1, 2), new ItemStack(plantGrowable, 1, 2), 1);
        RecipeHelper.addSoakRecipe(new ItemStack(plantStatic, 1, 9), new ItemStack(plantGrowable, 1, 9), 1);
        RecipeHelper.addSoakRecipe(new ItemStack(plantStatic, 1, 3), new ItemStack(plantGrowable, 1, 3), 1);
        RecipeHelper.addSoakRecipe(new ItemStack(plantStatic, 1, 10), new ItemStack(plantGrowable, 1, 10), 5);
        RecipeHelper.addSoakRecipe(new ItemStack(plantStatic, 1, 11), new ItemStack(plantGrowable, 1, 11), 1);
        RecipeHelper.addSoakRecipe(new ItemStack(plantStatic, 1, 12), new ItemStack(plantGrowable, 1, 12), 1);
        RecipeHelper.add9x9Recipe(new ItemStack(Core.food, 1, 8), "plantKelp");
        RecipeHelper.addShapeless(new ItemStack(Core.crafting, 1, 21), new Object[]{new ItemStack(plantStatic, 1, 1)});
        RecipeHelper.addSmelting(new ItemStack(Core.glass, 1, 0), new ItemStack(Core.sands, 1, 1), 0.025f);
        this.addOceanChestLoot();
    }

    private void addOceanChestLoot() {
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151103_aS, 7, 0), 5, 10, 25));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151144_bL, 1, 0), 5, 5, 5));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151144_bL, 1, 1), 2, 3, 3));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Blocks.field_150335_W), 2, 4, 4));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151121_aF, 3, 0), 2, 3, 20));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151122_aG, 1, 0), 2, 3, 15));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151062_by, 1, 0), 5, 10, 20));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151099_bA, 1, 0), 1, 4, 4));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack((Item)Items.field_151148_bJ, 1, 0), 1, 1, 5));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151043_k, 1, 0), 10, 20, 10));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151045_i, 1, 0), 1, 2, 3));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Core.materials, 1, 2), 1, 3, 4));
        if (Modules.isActive(Modules.factory)) {
            ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Factory.fludd), 1, 2, 1));
        }
        if (Modules.isActive(Modules.fishery)) {
            ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Fishery.rodReed), 1, 2, 6));
            ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Fishery.rodWood), 1, 2, 4));
            ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Fishery.rodTitanium), 1, 1, 2));
        } else {
            ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151115_aP, 1, 0), 5, 5, 5));
            ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151115_aP, 1, 1), 5, 5, 5));
            ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151115_aP, 1, 2), 5, 5, 5));
            ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151115_aP, 1, 3), 5, 5, 5));
        }
    }
}

