/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core;

import java.util.ArrayList;
import mariculture.api.core.FuelInfo;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeSmelter;
import mariculture.core.Core;
import mariculture.core.helpers.ItemHelper;
import mariculture.core.helpers.RecipeHelper;
import mariculture.core.lib.ItemLib;
import mariculture.core.lib.MetalRates;
import mariculture.core.util.Fluids;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipesSmelting {
    public static int iron = 1538;
    public static int gold = 1064;
    public static int tin = 232;
    public static int copper = 1085;
    public static int silver = 962;
    public static int lead = 328;
    public static int magnesium = 650;
    public static int nickel = 1455;
    public static int bronze = 950;
    public static int steel = 1370;
    public static int aluminum = 660;
    public static int titanium = 1662;
    public static int electrum = 1000;
    public static int alloy = 1725;

    public static void addRecipe(String fluidName, Object[] item, int[] volume, int temperature) {
        RecipesSmelting.addRecipe(fluidName, item, volume, temperature, null, 0);
    }

    public static void addRecipe(String fluidName, Object[] item, int[] volume, int temperature, ItemStack bonus, int chance) {
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            return;
        }
        for (int i = 0; i < item.length; ++i) {
            Object o = item[i];
            ArrayList stacks = new ArrayList();
            if (o instanceof String) {
                stacks = OreDictionary.getOres((String)((String)o));
            } else if (o instanceof ItemStack) {
                stacks.add((ItemStack)o);
            } else if (o instanceof Block) {
                stacks.add(new ItemStack((Block)o));
            } else if (o instanceof Item) {
                stacks.add(new ItemStack((Item)o));
            }
            for (ItemStack stack : stacks) {
                if (bonus == null || chance <= 0) {
                    RecipeHelper.addMelting(stack, temperature, new FluidStack(fluid, volume[i]));
                    continue;
                }
                RecipeHelper.addMelting(stack, temperature, new FluidStack(fluid, volume[i]), bonus, chance);
            }
        }
    }

    public static void add() {
        RecipesSmelting.addFuels();
        RecipesSmelting.addMetalRecipes();
    }

    public static void postAdd() {
        ItemStack sulfur = RecipesSmelting.fetchItem(new String[]{"dustSulfur", "crystalSulfur"});
        ItemStack salt = new ItemStack(Core.materials, 1, 12);
        ItemStack silicon = RecipesSmelting.fetchItem(new String[]{"itemSilicon", "dustSiliconDioxide"});
        ItemStack platinum = RecipesSmelting.fetchItem(new String[]{"dustPlatinum", "ingotPlatinum"});
        LinkedMetal[] alums = new LinkedMetal[]{new LinkedMetal("tin", 7), new LinkedMetal("iron", 5), new LinkedMetal("rutile", 35)};
        RecipesSmelting.addDust(5, aluminum, null, 0, alums);
        LinkedMetal[] coppers = new LinkedMetal[]{new LinkedMetal("iron", 4), new LinkedMetal("silver", 7), new LinkedMetal("gold", 10), new LinkedMetal("cobalt", 15), new LinkedMetal("nickel", 8), new LinkedMetal("lead", 7), new LinkedMetal("tin", 6)};
        RecipesSmelting.addDust(9, copper, sulfur, 10, coppers);
        LinkedMetal[] golds = new LinkedMetal[]{new LinkedMetal("electrum", 3), new LinkedMetal("silver", 7), new LinkedMetal("gold", 25)};
        RecipesSmelting.addDust(10, gold, null, 0, golds);
        LinkedMetal[] irons = new LinkedMetal[]{new LinkedMetal("aluminum", 3), new LinkedMetal("tin", 8), new LinkedMetal("copper", 6)};
        RecipesSmelting.addDust(11, iron, silicon, 6, irons);
        LinkedMetal[] leads = new LinkedMetal[]{new LinkedMetal("silver", 3), new LinkedMetal("iron", 6), new LinkedMetal("copper", 8), new LinkedMetal("tin", 10)};
        RecipesSmelting.addDust(7, lead, null, 0, leads);
        LinkedMetal[] silvers = new LinkedMetal[]{new LinkedMetal("lead", 2), new LinkedMetal("electrum", 4)};
        RecipesSmelting.addDust(6, silver, sulfur, 5, silvers);
        LinkedMetal[] tins = new LinkedMetal[]{new LinkedMetal("copper", 3), new LinkedMetal("iron", 6), new LinkedMetal("lead", 8)};
        RecipesSmelting.addDust(8, tin, sulfur, 7, tins);
        RecipesSmelting.addMetal(Fluids.getFluidName("tin"), "Tin", tin, new ItemStack(Core.materials, 1, 8), 10);
        RecipesSmelting.addMetal(Fluids.getFluidName("copper"), "Copper", copper, new ItemStack(Core.materials, 1, 9), 10);
        RecipesSmelting.addMetal(Fluids.getFluidName("silver"), "Silver", silver, new ItemStack(Core.materials, 1, 6), 10);
        RecipesSmelting.addMetal(Fluids.getFluidName("lead"), "Lead", lead, new ItemStack(Core.materials, 1, 7), 10);
        RecipesSmelting.addMetal(Fluids.getFluidName("nickel"), "Nickel", nickel, platinum, 10);
        RecipesSmelting.addMetal(Fluids.getFluidName("bronze"), "Bronze", bronze, null, 0);
        RecipesSmelting.addMetal(Fluids.getFluidName("steel"), "Steel", steel, null, 0);
        RecipesSmelting.addMetal(Fluids.getFluidName("electrum"), "Electrum", electrum, null, 0);
        if (OreDictionary.getOres((String)"ingotElectrum").size() > 0 && OreDictionary.getOres((String)"ingotSilver").size() > 0) {
            FluidStack moltenSilver = Fluids.getFluidStack("silver", MetalRates.NUGGET);
            FluidStack moltenGold = Fluids.getFluidStack("gold", MetalRates.NUGGET);
            FluidStack moltenElectrum = Fluids.getFluidStack("electrum", MetalRates.NUGGET * 2);
            RecipeHelper.addFluidAlloy(moltenSilver, moltenGold, moltenElectrum, 1);
        }
    }

    private static void addDust(int meta, int temp, ItemStack bonus, int chance, LinkedMetal[] metals) {
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        ArrayList<Integer> chances = new ArrayList<Integer>();
        for (LinkedMetal metal : metals) {
            if (Fluids.getFluid(metal.metal) == null) continue;
            fluids.add(Fluids.getFluidStack(metal.metal, MetalRates.INGOT));
            chances.add(metal.chance);
        }
        if (fluids.size() > 0) {
            MaricultureHandlers.crucible.addRecipe(new RecipeSmelter(new ItemStack(Core.materials, 1, meta), temp, fluids.toArray(new FluidStack[fluids.size()]), chances.toArray(new Integer[chances.size()]), bonus, chance));
        }
    }

    private static ItemStack fetchItem(String[] array) {
        for (String arr : array) {
            if (OreDictionary.getOres((String)arr).size() <= 0) continue;
            return (ItemStack)OreDictionary.getOres((String)arr).get(0);
        }
        return null;
    }

    private static void addFuels() {
        RecipeHelper.addFuel("blockCoal", new FuelInfo(2000, 378, 10800));
        RecipeHelper.addFuel(new ItemStack(Items.field_151044_h, 1, 0), new FuelInfo(2000, 42, 1200));
        RecipeHelper.addFuel(new ItemStack(Items.field_151044_h, 1, 1), new FuelInfo(1600, 32, 900));
        RecipeHelper.addFuel("logWood", new FuelInfo(480, 12, 300));
        RecipeHelper.addFuel("plankWood", new FuelInfo(320, 8, 200));
        RecipeHelper.addFuel("stickWood", new FuelInfo(160, 4, 100));
        RecipeHelper.addFuel(Fluids.getFluidName("natural_gas"), new FuelInfo(2000, 35, 1200));
        RecipeHelper.addFuel("gascraft_naturalgas", new FuelInfo(2000, 35, 1000));
        RecipeHelper.addFuel("fuel", new FuelInfo(2000, 35, 1000));
        RecipeHelper.addFuel("pyrotheum", new FuelInfo(2000, 100, 100));
        RecipeHelper.addFuel("coal", new FuelInfo(2000, 40, 300));
        RecipeHelper.addFuel("biofuel", new FuelInfo(1800, 20, 2000));
        RecipeHelper.addFuel("oil", new FuelInfo(1750, 20, 400));
        RecipeHelper.addFuel("lava", new FuelInfo(1500, 20, 360));
        RecipeHelper.addFuel("biomass", new FuelInfo(1500, 10, 1800));
        RecipeHelper.addFuel("bioethanol", new FuelInfo(1500, 10, 1800));
        RecipeHelper.addFuel("hootch", new FuelInfo(1800, 35, 250));
        RecipeHelper.addFuel("fire_water", new FuelInfo(1900, 40, 500));
        RecipeHelper.addFuel("rocket_fuel", new FuelInfo(2000, 45, 750));
    }

    public static void addFullSet(String fluid, Object[] items, int temp, ItemStack output, int chance) {
        RecipesSmelting.addRecipe(fluid, new Object[]{items[0]}, MetalRates.ORES, temp, output, chance);
        RecipesSmelting.addRecipe(fluid, new Object[]{items[1], items[2], items[3], items[4]}, MetalRates.METALS, temp);
        RecipesSmelting.addRecipe(fluid, new Object[]{items[5], items[6], items[7], items[8], items[9]}, MetalRates.TOOLS, temp, new ItemStack(Items.field_151055_y), 1);
        RecipesSmelting.addRecipe(fluid, new Object[]{items[10], items[11], items[12], items[13]}, MetalRates.ARMOR, temp);
    }

    public static void addMetal(String fluid, String metal, int temp, ItemStack bonus, int chance) {
        RecipesSmelting.addRecipe(fluid, new Object[]{"ore" + metal}, MetalRates.ORES, temp, bonus, chance);
        RecipesSmelting.addRecipe(fluid, new Object[]{"nugget" + metal, "ingot" + metal, "block" + metal, "dust" + metal}, MetalRates.METALS, temp);
        if (OreDictionary.getOres((String)("ingot" + metal)).size() > 0) {
            RecipeHelper.addMetalCasting(metal);
        }
    }

    public static void addMetalRecipes() {
        RecipesSmelting.addFullSet(Fluids.getFluidName("iron"), new Object[]{"oreIron", "nuggetIron", "ingotIron", "blockIron", "dustIron", Items.field_151035_b, Items.field_151037_a, Items.field_151036_c, Items.field_151040_l, Items.field_151019_K, Items.field_151028_Y, Items.field_151030_Z, Items.field_151165_aa, Items.field_151167_ab}, iron, new ItemStack(Core.materials, 1, 11), 10);
        RecipeHelper.addMetalCasting("silver");
        RecipesSmelting.addFullSet(Fluids.getFluidName("gold"), new Object[]{"oreGold", "nuggetGold", "ingotGold", "blockGold", "dustGold", Items.field_151005_D, Items.field_151011_C, Items.field_151006_E, Items.field_151010_B, Items.field_151013_M, Items.field_151169_ag, Items.field_151171_ah, Items.field_151149_ai, Items.field_151151_aj}, gold, new ItemStack(Core.materials, 1, 10), 10);
        RecipeHelper.addMetalCasting("Gold");
        RecipesSmelting.addMetal(Fluids.getFluidName("aluminum"), "Aluminum", aluminum, new ItemStack(Core.materials, 1, 5), 10);
        RecipesSmelting.addMetal(Fluids.getFluidName("rutile"), "Rutile", titanium, ItemLib.limestone, 2);
        RecipesSmelting.addMetal(Fluids.getFluidName("titanium"), "Titanium", titanium, ItemLib.limestone, 2);
        RecipesSmelting.addMetal(Fluids.getFluidName("magnesium"), "Magnesium", magnesium, new ItemStack(ItemLib.stone), 2);
        FluidStack moltenRutile = Fluids.getFluidStack("rutile", MetalRates.INGOT);
        FluidStack moltenMagnesium = Fluids.getFluidStack("magnesium", MetalRates.INGOT);
        FluidStack moltenTitanium = Fluids.getFluidStack("titanium", MetalRates.INGOT);
        RecipeHelper.addFluidAlloy(moltenRutile, moltenMagnesium, moltenTitanium, 6);
        RecipeHelper.addMelting(ItemLib.dustMagnesium, magnesium, RecipesSmelting.get(Fluids.getFluidName("magnesium")), ItemLib.salt, 1);
        RecipeHelper.addMelting(new ItemStack(Blocks.field_150445_bS), gold, RecipesSmelting.gold(MetalRates.INGOT * 2));
        RecipeHelper.addMelting(new ItemStack(Items.field_151113_aN), gold, RecipesSmelting.gold(MetalRates.INGOT * 4), new ItemStack(Items.field_151137_ax), 2);
        RecipeHelper.addMelting(new ItemStack(Items.field_151136_bY), gold, RecipesSmelting.gold(MetalRates.INGOT * 6), new ItemStack(Items.field_151141_av), 4);
        RecipeHelper.addMelting(new ItemStack(Items.field_151133_ar), iron, Fluids.getFluidName("iron"), MetalRates.INGOT * 3);
        RecipeHelper.addMelting(new ItemStack(Items.field_151139_aw), iron, Fluids.getFluidName("iron"), MetalRates.INGOT * 6);
        RecipeHelper.addMelting(new ItemStack(Blocks.field_150411_aY), iron, Fluids.getFluidName("iron"), (int)((double)MetalRates.INGOT * 0.25));
        RecipeHelper.addMelting(new ItemStack((Item)Items.field_151097_aZ), iron, Fluids.getFluidName("iron"), MetalRates.INGOT * 2);
        RecipeHelper.addMelting(new ItemStack(Blocks.field_150467_bQ, 1, 0), iron, Fluids.getFluidName("iron"), MetalRates.INGOT * 31);
        RecipeHelper.addMelting(new ItemStack(Blocks.field_150467_bQ, 1, 1), iron, Fluids.getFluidName("iron"), MetalRates.INGOT * 22);
        RecipeHelper.addMelting(new ItemStack(Blocks.field_150467_bQ, 1, 2), iron, Fluids.getFluidName("iron"), MetalRates.INGOT * 13);
        RecipeHelper.addMelting(new ItemStack(Blocks.field_150443_bT), iron, Fluids.getFluidName("iron"), MetalRates.INGOT * 2);
        RecipeHelper.addMelting(new ItemStack(Items.field_151111_aL), iron, RecipesSmelting.iron(MetalRates.INGOT * 4), new ItemStack(Items.field_151137_ax), 2);
        RecipeHelper.addMelting(new ItemStack((Block)Blocks.field_150438_bZ), iron, RecipesSmelting.iron(MetalRates.INGOT * 5), new ItemStack((Block)Blocks.field_150486_ae), 2);
        RecipeHelper.addMelting(new ItemStack(Items.field_151033_d), iron, RecipesSmelting.iron(MetalRates.INGOT));
        RecipeHelper.addMelting(new ItemStack(Items.field_151138_bX), iron, RecipesSmelting.iron(MetalRates.INGOT * 6), new ItemStack(Items.field_151141_av), 4);
        RecipeHelper.addBlockCasting(RecipesSmelting.get(Fluids.getFluidName("glass"), 1000), new ItemStack(ItemLib.glass));
        RecipeHelper.addMelting(new ItemStack(ItemLib.sand), 1000, Fluids.getFluidName("glass"), 1000);
        RecipeHelper.addMelting(new ItemStack(ItemLib.glass), 900, Fluids.getFluidName("glass"), 1000);
        RecipeHelper.addMelting(new ItemStack(ItemLib.glassPane), 500, Fluids.getFluidName("glass"), 375);
        RecipeHelper.addMelting(new ItemStack(ItemLib.ice), 1, "water", 1000);
        RecipeHelper.addMelting(new ItemStack(ItemLib.blockSnow), 1, "water", 1000);
        RecipeHelper.addVatItemRecipe(new ItemStack(ItemLib.glass, 32), Fluids.getFluidName("natural_gas"), 25000, new ItemStack(Core.transparent, 32, 0), 60);
        RecipeHelper.addVatItemRecipe(new ItemStack(ItemLib.glass), Fluids.getFluidName("natural_gas"), 1000, new ItemStack(Core.transparent, 1, 0), 5);
        if (Fluids.getFluid("bioethanol") != null) {
            RecipeHelper.addVatItemRecipe(new ItemStack(ItemLib.glass, 32), Fluids.getFluidName("bioethanol"), 30000, new ItemStack(Core.transparent, 32, 0), 100);
            RecipeHelper.addVatItemRecipe(new ItemStack(ItemLib.glass), Fluids.getFluidName("bioethanol"), 1500, new ItemStack(Core.transparent, 1, 0), 10);
        }
        RecipeHelper.addFluidAlloyResultItem(RecipesSmelting.get("water", 1000), RecipesSmelting.get("lava", 1000), new ItemStack(ItemLib.obsidian), 10);
        RecipeHelper.addFluidAlloyResultItemNFluid(RecipesSmelting.get("water", 3000), RecipesSmelting.get(Fluids.getFluidName("quicklime"), 4000), RecipesSmelting.get("water", 2000), ItemLib.dustMagnesium, 10);
        ArrayList<ItemStack> added = new ArrayList<ItemStack>();
        for (ItemStack stack : OreDictionary.getOres((String)"blockLimestone")) {
            if (stack == null || stack.func_77973_b() == null) continue;
            RecipeHelper.addMelting(stack, 825, RecipesSmelting.get(Fluids.getFluidName("quicklime"), 900));
            added.add(stack);
        }
        for (ItemStack stack : OreDictionary.getOres((String)"limestone")) {
            boolean exists = false;
            if (stack == null || stack.func_77973_b() == null) continue;
            for (ItemStack check : added) {
                if (!ItemHelper.areEqual(stack, check)) continue;
                exists = true;
            }
            if (exists) continue;
            RecipeHelper.addMelting(stack, 825, RecipesSmelting.get(Fluids.getFluidName("quicklime"), 900));
        }
        RecipeHelper.addNuggetCasting(new FluidStack(FluidRegistry.WATER, 250), ItemLib.salt);
        RecipeHelper.addMelting(ItemLib.limestoneSmooth, 825, RecipesSmelting.get(Fluids.getFluidName("quicklime"), 1000));
        RecipeHelper.addMelting(ItemLib.dustSalt, 801, RecipesSmelting.get(Fluids.getFluidName("salt"), 20));
        RecipeHelper.addFluidAlloyNItemResultItem(RecipesSmelting.get(Fluids.getFluidName("aluminum"), MetalRates.NUGGET * 64), RecipesSmelting.get(Fluids.getFluidName("quicklime"), 20000), new ItemStack(ItemLib.glass, 64), new ItemStack(Core.glass, 64, 0), 90);
        RecipeHelper.addFluidAlloyNItemResultItem(RecipesSmelting.get(Fluids.getFluidName("aluminum"), MetalRates.NUGGET), RecipesSmelting.get(Fluids.getFluidName("quicklime"), 450), new ItemStack(ItemLib.glass), new ItemStack(Core.glass, 1, 0), 5);
    }

    public static FluidStack gold(int vol) {
        return Fluids.getFluidStack("gold", vol);
    }

    public static FluidStack iron(int vol) {
        return Fluids.getFluidStack("iron", vol);
    }

    public static FluidStack get(String name, int vol) {
        return FluidRegistry.getFluidStack((String)name, (int)vol);
    }

    public static FluidStack get(String name) {
        return FluidRegistry.getFluidStack((String)name, (int)MetalRates.INGOT);
    }

    private static class LinkedMetal {
        public String metal;
        public Integer chance;

        public LinkedMetal(String metal, Integer chance) {
            this.metal = metal;
            this.chance = chance;
        }
    }
}

