/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.RetroData;
import mariculture.core.config.WorldGeneration;
import mariculture.core.handlers.LogHandler;
import mariculture.core.handlers.WorldEventHandler;
import mariculture.core.handlers.WorldGenHandler;
import mariculture.core.lib.Modules;
import mariculture.world.GenerationHandler;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;
import org.apache.logging.log4j.Level;

public class RetroGeneration {
    public static ArrayList<String> retro;

    public boolean doGen(RetroData data, String ore, Chunk chunk) {
        try {
            Field field = WorldGeneration.RetroGen.class.getField(ore.toUpperCase());
            boolean isEnabled = field.getBoolean(WorldGeneration.RetroGen.class);
            if ((isEnabled || WorldGeneration.RetroGen.ALL) && !data.hasRetroGenned(ore, chunk) && data.setHasRetroGenned(ore, chunk)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ore = ore.substring(0, 1).toUpperCase() + ore.substring(1);
            LogHandler.log(Level.WARN, "Retro-Gen of " + ore + " Failed");
        }
        return false;
    }

    @SubscribeEvent
    public void onChunk(ChunkEvent.Load event) {
        if (WorldEventHandler.isBlacklisted(event.world.field_73011_w.field_76574_g)) {
            return;
        }
        if (!event.world.field_72995_K) {
            Chunk chunk = event.getChunk();
            RetroData data = (RetroData)event.world.field_72988_C.func_75742_a(RetroData.class, "retrogen-mariculture");
            if (data == null || data != null && data.getLastKey() != WorldGeneration.RetroGen.KEY) {
                data = new RetroData();
                event.world.func_72823_a("retrogen-mariculture", (WorldSavedData)data);
            }
            if (retro == null) {
                retro = new ArrayList();
            }
            if (chunk.field_76636_d) {
                try {
                    int x = chunk.field_76635_g * 16;
                    int z = chunk.field_76647_h * 16;
                    if (WorldGeneration.OreGen.NATURAL_GAS_ON && this.doGen(data, "gas", chunk)) {
                        WorldGenHandler.generateGas(chunk.field_76637_e, chunk.field_76637_e.field_73012_v, x, z);
                    }
                    if (WorldGeneration.OreGen.BAUXITE_ON && this.doGen(data, "bauxite", chunk)) {
                        WorldGenHandler.generateBauxite(chunk.field_76637_e, chunk.field_76637_e.field_73012_v, x, z);
                    }
                    if (WorldGeneration.OreGen.COPPER_ON && this.doGen(data, "copper", chunk)) {
                        WorldGenHandler.generateCopper(chunk.field_76637_e, chunk.field_76637_e.field_73012_v, x, z);
                    }
                    if (WorldGeneration.WorldGen.OYSTER_ENABLED && this.doGen(data, "oyster", chunk)) {
                        WorldGenHandler.generateOyster(chunk.field_76637_e, chunk.field_76637_e.field_73012_v, x, z);
                    }
                    if (Modules.isActive(Modules.worldplus) && MaricultureHandlers.environment.getSalinity(chunk.field_76637_e, x, z) == Environment.Salinity.SALINE) {
                        if (WorldGeneration.WorldGen.KELP_FOREST_ENABLED && this.doGen(data, "kelp", chunk)) {
                            GenerationHandler.kelpGenerator.func_76484_a(chunk.field_76637_e, chunk.field_76637_e.field_73012_v, x, 0, z);
                        }
                        if (WorldGeneration.WorldGen.CORAL_REEF_ENABLED && this.doGen(data, "coralreef", chunk)) {
                            GenerationHandler.generateCoralReef(chunk.field_76637_e, chunk.field_76637_e.field_73012_v, chunk.field_76635_g, chunk.field_76647_h);
                        }
                        if (WorldGeneration.WorldGen.ANCIENT_SAND_ENABLED && this.doGen(data, "ancient", chunk)) {
                            GenerationHandler.generateAncientSand(chunk.field_76637_e, chunk.field_76637_e.field_73012_v, chunk.field_76635_g, chunk.field_76647_h);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

