/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import mariculture.api.core.MaricultureTab;
import mariculture.core.blocks.base.BlockDecorative;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.lib.Extra;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockGround
extends BlockDecorative {
    public BlockGround() {
        super(Material.field_151595_p);
    }

    @Override
    public String getToolType(int meta) {
        return "shovel";
    }

    @Override
    public int getToolLevel(int meta) {
        return meta == 0 ? 0 : 1;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.7f;
            }
        }
        return 3.0f;
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            int i = y;
            while (BlockHelper.isWater(world, x, i + 1, z)) {
                for (int j = 0; j < 2; ++j) {
                    float f = rand.nextFloat() - rand.nextFloat();
                    float f1 = rand.nextFloat() - rand.nextFloat();
                    float f2 = rand.nextFloat() - rand.nextFloat();
                    world.func_72869_a("bubble", (double)x + 0.5 + (double)f, (double)i + (double)f1, (double)z + 0.5 + (double)f2, 0.0, 0.0, 0.0);
                }
                ++i;
            }
        }
    }

    @Override
    public Item func_149650_a(int meta, Random random, int j) {
        return Item.func_150898_a((Block)Blocks.field_150354_m);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            if (metadata == 1) {
                if (!Extra.NERF_FOOD) {
                    if (world.field_73012_v.nextInt(7) <= fortune) {
                        ret.add(new ItemStack(Items.field_151103_aS));
                    }
                    if (world.field_73012_v.nextInt(3) <= fortune) {
                        ret.add(new ItemStack(Items.field_151100_aR, 1, 15));
                    }
                }
                if (world.field_73012_v.nextInt(15) <= fortune) {
                    ret.add(new ItemStack(Items.field_151100_aR, 1, 0));
                }
                if (world.field_73012_v.nextInt(64) <= fortune) {
                    ret.add(new ItemStack(Items.field_151074_bl));
                }
                if (world.field_73012_v.nextInt(48) <= fortune) {
                    ret.add(new ItemStack((Block)Blocks.field_150486_ae));
                }
                if (world.field_73012_v.nextInt(52) <= fortune) {
                    ret.add(new ItemStack(Blocks.field_150447_bR));
                }
                if (ret.size() != 0) continue;
                ret.add(new ItemStack((Block)this, 1, 1));
                continue;
            }
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, this.func_149692_a(metadata)));
        }
        return ret;
    }

    @Override
    public boolean isValidTab(CreativeTabs tab, int meta) {
        return tab == MaricultureTab.tabWorld;
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0) {
            return Blocks.field_150354_m.func_149691_a(side, meta);
        }
        return this.field_149761_L;
    }

    @Override
    public int getMetaCount() {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("mariculture:ancientSand");
    }
}

