/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mariculture.api.core.MaricultureTab;
import mariculture.core.Core;
import mariculture.core.blocks.base.BlockFunctional;
import mariculture.core.lib.Modules;
import mariculture.core.network.PacketHandler;
import mariculture.core.network.PacketSponge;
import mariculture.core.tile.TileBookshelf;
import mariculture.core.util.IFaceable;
import mariculture.factory.tile.TileDictionaryItem;
import mariculture.factory.tile.TileFishSorter;
import mariculture.factory.tile.TileGenerator;
import mariculture.factory.tile.TileSawmill;
import mariculture.factory.tile.TileSluice;
import mariculture.factory.tile.TileSluiceAdvanced;
import mariculture.factory.tile.TileSponge;
import mariculture.factory.tile.TileUnpacker;
import mariculture.fishery.tile.TileAutofisher;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMachine
extends BlockFunctional {
    private IIcon[] fishSorter;
    private IIcon sluiceAdvanced;
    private IIcon sluiceAdvancedBack;
    private IIcon sluiceAdvancedUp;
    private IIcon sluiceAdvancedDown;
    private IIcon sluiceBack;
    private IIcon sluiceUp;
    private IIcon sluiceDown;
    private IIcon unpacker;
    private IIcon generatorBack;

    public BlockMachine() {
        super(Material.field_76233_E);
    }

    @Override
    public String getToolType(int meta) {
        switch (meta) {
            case 3: {
                return "pickaxe";
            }
            case 4: {
                return "pickaxe";
            }
            case 8: {
                return "pickaxe";
            }
            case 9: {
                return "generator";
            }
        }
        return "axe";
    }

    @Override
    public int getToolLevel(int meta) {
        switch (meta) {
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 1;
            }
        }
        return 0;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                return 1.0f;
            }
            case 1: {
                return 2.0f;
            }
            case 2: {
                return 2.0f;
            }
            case 3: {
                return 5.0f;
            }
            case 4: {
                return 2.5f;
            }
            case 5: {
                return 2.0f;
            }
            case 6: {
                return 1.5f;
            }
            case 7: {
                return 1.5f;
            }
            case 8: {
                return 7.5f;
            }
            case 9: {
                return 3.5f;
            }
        }
        return 1.0f;
    }

    public float getEnchantPowerBonus(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 0 ? 5.0f : 0.0f;
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 6) {
            return this.fishSorter[side];
        }
        if (meta == 3) {
            return side == 3 ? this.icons[3] : Core.metals.func_149691_a(side, 5);
        }
        if (meta == 9) {
            return side == 3 ? this.icons[9] : Core.metals.func_149691_a(side, 5);
        }
        if (meta == 8) {
            return side == 3 ? this.icons[8] : this.sluiceAdvanced;
        }
        if (side < 2) {
            if (meta == 0) {
                return Blocks.field_150344_f.func_149691_a(side, meta);
            }
            if (meta == 4) {
                return Core.metals.func_149691_a(side, 5);
            }
            if (meta == 7) {
                return this.unpacker;
            }
            return Core.woods.func_149691_a(side, 0);
        }
        return super.func_149691_a(side, meta);
    }

    public IIcon func_149673_e(IBlockAccess block, int x, int y, int z, int side) {
        TileEntity tile = block.func_147438_o(x, y, z);
        if (tile instanceof TileBookshelf) {
            return Blocks.field_150342_X.func_149691_a(side, 0);
        }
        if (tile instanceof TileSluice) {
            TileSluice sluice = (TileSluice)tile;
            if (tile instanceof TileSluiceAdvanced) {
                if (sluice.orientation.ordinal() == side) {
                    return side > 1 ? this.icons[8] : this.sluiceAdvancedUp;
                }
                if (sluice.orientation.getOpposite().ordinal() == side) {
                    return side > 1 ? this.sluiceAdvancedBack : this.sluiceAdvancedDown;
                }
                return this.sluiceAdvanced;
            }
            if (sluice.orientation.ordinal() == side) {
                return side > 1 ? this.icons[3] : this.sluiceUp;
            }
            if (sluice.orientation.getOpposite().ordinal() == side) {
                return side > 1 ? this.sluiceBack : this.sluiceDown;
            }
            return Core.metals.func_149691_a(side, 5);
        }
        if (tile instanceof TileGenerator) {
            TileGenerator generator = (TileGenerator)tile;
            return generator.orientation.ordinal() == side ? this.icons[9] : (generator.orientation.getOpposite().ordinal() == side ? this.generatorBack : Core.metals.func_149691_a(side, 5));
        }
        return super.func_149673_e(block, x, y, z, side);
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity tile = world.func_147438_o(x, y, z);
        int facing = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entity);
        if (tile instanceof IFaceable) {
            IFaceable face = (IFaceable)tile;
            face.setFacing(ForgeDirection.getOrientation((int)facing));
            if (tile instanceof TileGenerator) {
                ((TileGenerator)tile).reset();
            }
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || player.func_70093_af() || tile instanceof TileSluice || tile instanceof TileGenerator) {
            return false;
        }
        if (tile instanceof TileSponge) {
            Item currentItem;
            if (world.field_72995_K && player instanceof EntityClientPlayerMP) {
                PacketHandler.sendToServer(new PacketSponge(x, y, z, true));
            } else if (player.func_71045_bC() != null && !world.field_72995_K && (currentItem = player.func_71045_bC().func_77973_b()) instanceof IEnergyContainerItem && !world.field_72995_K) {
                int powerAdd = ((IEnergyContainerItem)currentItem).extractEnergy(player.func_71045_bC(), 5000, true);
                int reduce = ((IEnergyHandler)tile).receiveEnergy(ForgeDirection.UNKNOWN, powerAdd, false);
                ((IEnergyContainerItem)currentItem).extractEnergy(player.func_71045_bC(), reduce, false);
            }
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    private void clearWater(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o() == Material.field_151586_h) {
            world.func_147468_f(x, y, z);
        }
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        if (meta == 3) {
            this.clearWater(world, x + 1, y, z);
            this.clearWater(world, x - 1, y, z);
            this.clearWater(world, x, y, z + 1);
            this.clearWater(world, x, y, z - 1);
        }
    }

    @Override
    public TileEntity createTileEntity(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileBookshelf();
            }
            case 1: {
                return new TileDictionaryItem();
            }
            case 2: {
                return new TileSawmill();
            }
            case 3: {
                return new TileSluice();
            }
            case 4: {
                return new TileSponge();
            }
            case 5: {
                return new TileAutofisher();
            }
            case 6: {
                return new TileFishSorter();
            }
            case 7: {
                return new TileUnpacker();
            }
            case 8: {
                return new TileSluiceAdvanced();
            }
            case 9: {
                return new TileGenerator();
            }
        }
        return null;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        if (world.func_72805_g(x, y, z) == 0) {
            return Container.func_94526_b((IInventory)((IInventory)world.func_147438_o(x, y, z)));
        }
        return super.func_149736_g(world, x, y, z, side);
    }

    @Override
    public boolean isActive(int meta) {
        switch (meta) {
            case 0: {
                return true;
            }
            case 1: {
                return Modules.isActive(Modules.factory);
            }
            case 2: {
                return Modules.isActive(Modules.factory);
            }
            case 3: {
                return Modules.isActive(Modules.factory);
            }
            case 4: {
                return Modules.isActive(Modules.factory);
            }
            case 5: {
                return Modules.isActive(Modules.fishery);
            }
            case 6: {
                return Modules.isActive(Modules.fishery);
            }
            case 7: {
                return Modules.isActive(Modules.factory);
            }
            case 8: {
                return Modules.isActive(Modules.factory);
            }
            case 9: {
                return Modules.isActive(Modules.factory);
            }
        }
        return true;
    }

    @Override
    public boolean isValidTab(CreativeTabs tab, int meta) {
        switch (meta) {
            case 5: {
                return tab == MaricultureTab.tabFishery;
            }
            case 6: {
                return tab == MaricultureTab.tabFishery;
            }
        }
        return tab == MaricultureTab.tabFactory;
    }

    @Override
    public int getMetaCount() {
        return 10;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.fishSorter = new IIcon[6];
        for (int i = 0; i < 6; ++i) {
            this.fishSorter[i] = iconRegister.func_94245_a("mariculture:fishsorter" + (i + 1));
        }
        this.sluiceBack = iconRegister.func_94245_a("mariculture:sluiceBack");
        this.sluiceUp = iconRegister.func_94245_a("mariculture:sluiceUp");
        this.sluiceDown = iconRegister.func_94245_a("mariculture:sluiceDown");
        this.sluiceAdvancedBack = iconRegister.func_94245_a("mariculture:sluiceAdvancedBack");
        this.sluiceAdvancedUp = iconRegister.func_94245_a("mariculture:sluiceAdvancedUp");
        this.sluiceAdvancedDown = iconRegister.func_94245_a("mariculture:sluiceAdvancedDown");
        this.sluiceAdvanced = iconRegister.func_94245_a("mariculture:sluiceAdvancedSide");
        this.unpacker = iconRegister.func_94245_a("mariculture:unpackerTop");
        this.generatorBack = iconRegister.func_94245_a("mariculture:generatorBack");
    }
}

