/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mariculture.api.core.MaricultureTab;
import mariculture.core.Core;
import mariculture.core.blocks.BlockPearlBlock;
import mariculture.core.blocks.base.BlockFunctional;
import mariculture.core.config.Gardening;
import mariculture.core.config.GeneralStuff;
import mariculture.core.handlers.PearlGenHandler;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.DirectionHelper;
import mariculture.core.lib.Modules;
import mariculture.core.lib.RenderIds;
import mariculture.core.render.RenderOyster;
import mariculture.core.tile.TileOyster;
import mariculture.plugins.enchiridion.BookSpawnHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockWater
extends BlockFunctional {
    public BlockWater() {
        super(Material.field_151586_h);
        this.func_149675_a(true);
    }

    @Override
    public String getToolType(int meta) {
        return "pickaxe";
    }

    @Override
    public int getToolLevel(int meta) {
        return 1;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return 25.0f;
    }

    public int func_149645_b() {
        return RenderIds.RENDER_ALL;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        if (!BlockHelper.isWater(world, x, y + 1, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
        if (!world.isSideSolid(x, y - 1, z, ForgeDirection.UP)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return BlockHelper.isWater(world, x, y + 1, z) && world.isSideSolid(x, y - 1, z, ForgeDirection.UP);
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (stack.func_77960_j() == 0) {
            ((TileOyster)world.func_147438_o((int)x, (int)y, (int)z)).orientation = DirectionHelper.getFacingFromEntity(entity);
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || player.func_70093_af()) {
            return false;
        }
        if (tile instanceof TileOyster) {
            TileOyster oyster = (TileOyster)tile;
            if (GeneralStuff.SPAWN_BOOKS && Modules.isActive(Modules.magic) && oyster.func_70301_a(0) != null && oyster.func_70301_a(0).func_77973_b() == Core.pearls) {
                BookSpawnHelper.spawn(player, 4);
            }
            if (!player.func_70093_af() && !world.field_72995_K) {
                if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m) && oyster.func_70301_a(0) == null) {
                    oyster.func_70299_a(0, new ItemStack((Block)Blocks.field_150354_m));
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                    return true;
                }
                BlockHelper.dropItems(world, x, y, z);
                oyster.func_70299_a(0, null);
                return true;
            }
        }
        return true;
    }

    public void func_149719_a(IBlockAccess block, int x, int y, int z) {
        this.func_149676_a(0.05f, 0.0f, 0.05f, 0.95f, 0.1f, 0.95f);
    }

    @Override
    public TileEntity createTileEntity(World world, int meta) {
        return new TileOyster();
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.func_72805_g(x, y, z) == 0) {
            TileOyster oyster = (TileOyster)world.func_147438_o(x, y, z);
            if (!world.field_72995_K && oyster.hasSand() && BlockHelper.isWater(world, x, y + 1, z) && rand.nextInt(Math.max(1, Gardening.PEARL_GEN_CHANCE)) == 0) {
                Block block = world.func_147439_a(x, y - 1, z);
                if (world.field_73011_w.field_76574_g == 1) {
                    oyster.func_70299_a(0, new ItemStack(Items.field_151079_bi));
                }
                if (block instanceof BlockPearlBlock) {
                    oyster.func_70299_a(0, new ItemStack(Core.pearls, 1, world.func_72805_g(x, y - 1, z)));
                } else {
                    oyster.func_70299_a(0, PearlGenHandler.getRandomPearl(rand));
                }
            }
        }
    }

    @Override
    public int getMetaCount() {
        return 1;
    }

    @Override
    public boolean isValidTab(CreativeTabs tab, int meta) {
        return tab == MaricultureTab.tabWorld;
    }

    public int func_149677_c(IBlockAccess world, int x, int y, int z) {
        return world.func_72802_i(x, y, z, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        super.func_149651_a(register);
        RenderOyster.lid_blur = register.func_94245_a("mariculture:oysterLidBlur");
        RenderOyster.lid = register.func_94245_a("mariculture:oysterLid");
        RenderOyster.tongue = register.func_94245_a("mariculture:oysterTongue");
    }
}

