/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks.base;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mariculture.api.core.MaricultureTab;
import mariculture.core.util.IHasMeta;
import mariculture.core.util.IItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class BlockDecorative
extends Block
implements IHasMeta {
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] icons;
    protected String prefix;

    public BlockDecorative(Material material) {
        super(material);
        this.func_149647_a(MaricultureTab.tabCore);
        for (int i = 0; i < this.getMetaCount(); ++i) {
            this.setHarvestLevel(this.getToolType(i), this.getToolLevel(i), i);
        }
    }

    public abstract String getToolType(int var1);

    public abstract int getToolLevel(int var1);

    @Override
    public abstract int getMetaCount();

    public boolean isActive(int meta) {
        return true;
    }

    public boolean isValidTab(CreativeTabs tab, int meta) {
        return tab == MaricultureTab.tabCore;
    }

    public int func_149692_a(int i) {
        return i;
    }

    public Item func_149650_a(int meta, Random rand, int side) {
        return !this.doesDrop(meta) ? null : super.func_149650_a(meta, rand, side);
    }

    public boolean doesDrop(int meta) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creative, List list) {
        for (int meta = 0; meta < this.getMetaCount(); ++meta) {
            if (!this.isActive(meta) || !this.isValidTab(creative, meta)) continue;
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        if (this.field_149761_L != null) {
            return this.field_149761_L;
        }
        if (this.icons == null) {
            return Blocks.field_150348_b.func_149691_a(side, meta);
        }
        if (meta < this.getMetaCount()) {
            return this.icons[meta];
        }
        return this.icons[0];
    }

    protected String getName(int i) {
        return ((IItemRegistry)Item.func_150898_a((Block)this)).getName(new ItemStack((Block)this, 1, i));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        String name = this.prefix != null ? this.prefix : "";
        this.icons = new IIcon[this.getMetaCount()];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("mariculture:" + name + this.getName(i));
        }
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return null;
    }
}

