/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.config;

import mariculture.core.helpers.ConfigHelper;
import mariculture.core.lib.MachineSpeeds;
import net.minecraftforge.common.config.Configuration;

public class Machines {
    public static void init(Configuration config) {
        ConfigHelper.setConfig(config);
        ConfigHelper.setCategory("Speed Settings");
        MachineSpeeds.autofisher = ConfigHelper.getInt("Automatic Fisher", 2500);
        MachineSpeeds.feeder = ConfigHelper.getInt("Fish Feeder", 200);
        MachineSpeeds.incubator = ConfigHelper.getInt("Incubator", 400);
        MachineSpeeds.crucible = ConfigHelper.getInt("Crucible Furnace", 40000);
        MachineSpeeds.net = ConfigHelper.getInt("Fishing Net", 300);
        MachineSpeeds.sawmill = ConfigHelper.getInt("Sawmill", 650);
        MachineSpeeds.hatchery = ConfigHelper.getInt("Hatchery", 100);
        ConfigHelper.setCategory("Client Settings", "The settings only affect clientside");
        Client.GEYSER_ANIM = ConfigHelper.getBoolean("Geyser - Enable Particles", true);
        Client.FLUDD_BLOCK_ANIM = ConfigHelper.getBoolean("FLUDD - Enable Particles", true);
        Client.PUMP_ANIM = ConfigHelper.getBoolean("Air Pump - Enable Rotation", true, "This will not work if Enable Ticking is set to false under Tick Settings");
        Client.HAMMER_ANIM = ConfigHelper.getBoolean("Autohammer - Enabled Animation", true);
        Client.SHOW_FISH = ConfigHelper.getBoolean("Fish Feeder > Show Fish", true);
        ConfigHelper.setCategory("Tick Settings");
        Ticks.ITEM_EJECT_TICK = ConfigHelper.getInt("Item Eject Tick", 20);
        Ticks.FLUID_EJECT_TICK = ConfigHelper.getInt("Fluid Eject Tick", 100);
        Ticks.EFFECT_TICK = ConfigHelper.getInt("Fish Feeder > Effect Tick", 20, "This is how many ticks for an effect to occur in a fish tank, such as poison or regen");
        Ticks.PUMP_ENABLE_TICKS = ConfigHelper.getBoolean("Air Pump - Enable Ticking", true);
        Ticks.FISH_FOOD_TICK = ConfigHelper.getInt("Fish Feeder > Fish Food Tick Rate", 25, "This is how many minecraft ticks, before attempting to pick up fish food, set to 0 to disable");
        Ticks.PICKUP_TICK = ConfigHelper.getInt("Fish Feeder > Fish Food Pickup Tick Rate", -1, "How often it tries to pick up fish food, set to less than 0 to disable");
        Ticks.ADVANCED_SLUICE_TICK = ConfigHelper.getInt("Advanced Sluice > Tick Rate", 60);
        ConfigHelper.setCategory("Machine Settings");
        MachineSettings.PACKET_DISTANCE = ConfigHelper.getInt("How many blocks away to send rendering packet updates to players", 176);
        MachineSettings.PURITY = ConfigHelper.getInt("Crucible Furnace > mB Per Purity Upgrade Level", 32);
        MachineSettings.DRAGON_EGG_ETHEREAL = ConfigHelper.getInt("Incubator > Dragon Egg Chance - Ethereal", 48000, "Same as the normal chance but this is the chance when you have an ethereal upgrade in the incubator");
        MachineSettings.DRAGON_EGG_BASE = ConfigHelper.getInt("Incubator > Dragon Egg Chance", 64000, "This is a 1 in this many chance for the chance to get a Spawn Ender Dragon from a Dragon Egg");
        MachineSettings.ADVANCED_SLUICE_RADIUS = ConfigHelper.getInt("Advanced Sluice > Radius to Drain Fluids", 66);
        MachineSettings.ENABLE_PURITY_IN_CRUCIBLE = ConfigHelper.getBoolean("Crucible Furnace > Enable Purity Bonus", false);
        MachineSettings.ENABLE_ADVANCED_SLUICE_DRAIN = ConfigHelper.getBoolean("Advanced Sluice > Enable Overpowered, Laggy Draining", false);
    }

    public static class Ticks {
        public static int ITEM_EJECT_TICK;
        public static int FLUID_EJECT_TICK;
        public static int EFFECT_TICK;
        public static boolean PUMP_ENABLE_TICKS;
        public static int FISH_FOOD_TICK;
        public static int TANK_UPDATE;
        public static int PICKUP_TICK;
        public static int ADVANCED_SLUICE_TICK;
    }

    public static class MachineSettings {
        public static int PACKET_DISTANCE;
        public static int PURITY;
        public static int DRAGON_EGG_ETHEREAL;
        public static int DRAGON_EGG_BASE;
        public static int ADVANCED_SLUICE_RADIUS;
        public static boolean ENABLE_PURITY_IN_CRUCIBLE;
        public static boolean ENABLE_ADVANCED_SLUICE_DRAIN;
    }

    public static class Client {
        public static boolean SHOW_FISH;
        public static boolean PUMP_ANIM;
        public static boolean GEYSER_ANIM;
        public static boolean FLUDD_BLOCK_ANIM;
        public static boolean HAMMER_ANIM;
    }
}

