/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.gui.feature;

import java.util.List;
import mariculture.core.gui.GuiMariculture;
import mariculture.core.gui.feature.Feature;
import mariculture.core.util.IHasNotification;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class FeatureNotifications
extends Feature {
    public IHasNotification tile;
    public NotificationType[] notifications;

    public FeatureNotifications(IHasNotification tile, NotificationType[] noteTypes) {
        this.tile = tile;
        this.notifications = noteTypes;
    }

    @Override
    public void addTooltip(List tooltip, int mouseX, int mouseY) {
        int pos = 0;
        for (NotificationType note : this.notifications) {
            if (!this.tile.isNotificationVisible(note)) continue;
            if (mouseX >= -21 && mouseX <= 0 && mouseY >= 8 + 23 * pos && mouseY <= 8 + 23 * pos + 21) {
                tooltip.add("\u00a7c" + StatCollector.func_74838_a((String)("notification." + note.toString().toLowerCase().replaceAll("_", "\\."))));
                for (int i = 0; i < 5; ++i) {
                    this.addLine("notification", i, note.toString(), tooltip);
                }
            }
            ++pos;
        }
    }

    @Override
    public void draw(GuiMariculture gui, int x, int y, int mouseX, int mouseY) {
        super.draw(gui, x, y, mouseX, mouseY);
        int pos = 0;
        for (NotificationType note : this.notifications) {
            if (!this.tile.isNotificationVisible(note)) continue;
            float red = (float)(note.color >> 16 & 0xFF) / 255.0f;
            float green = (float)(note.color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(note.color & 0xFF) / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
            gui.func_73729_b(x - 21, y + 8 + 23 * pos, 176, 99, 21, 22);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.func_73729_b(x - 21 + 3, y + 8 + 2 + 23 * pos, note.x, note.y, 18, 18);
            ++pos;
        }
    }

    public static enum NotificationType {
        NO_ROD(0, 238, 15787660),
        NO_BAIT(18, 238, 9136489),
        NO_WATER(36, 238, 52945),
        NOT_FISHABLE(54, 238, 45806),
        NO_RF(72, 238, 0xC1CDCD),
        NO_PLAN(90, 238, 41945),
        MISSING_SIDE(108, 238, 0x888888),
        NO_FOOD(126, 238, 2994688),
        NO_MALE(144, 238, 7575295),
        NO_FEMALE(162, 238, 0xFF99FF),
        BAD_ENV(180, 238, 0x111111),
        NO_EGG(198, 238, 12434862);

        private int x;
        private int y;
        private int color;

        private NotificationType(int x, int y, int color) {
            this.x = x;
            this.y = y;
            this.color = color;
        }
    }
}

