/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.gui.feature;

import java.util.List;
import mariculture.core.gui.GuiMariculture;
import mariculture.core.gui.feature.Feature;
import mariculture.core.network.PacketClick;
import mariculture.core.network.PacketHandler;
import mariculture.core.util.IRedstoneControlled;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class FeatureRedstone
extends Feature {
    public IRedstoneControlled tile;
    public int x;
    public int y;
    public int z;

    public FeatureRedstone(IRedstoneControlled tile) {
        this.tile = tile;
        this.x = ((TileEntity)tile).field_145851_c;
        this.y = ((TileEntity)tile).field_145848_d;
        this.z = ((TileEntity)tile).field_145849_e;
    }

    @Override
    public void addTooltip(List tooltip, int mouseX, int mouseY) {
        if (mouseX >= 177 && mouseX <= 192 && mouseY >= 76 && mouseY <= 92) {
            tooltip.add("\u00a7c" + StatCollector.func_74838_a((String)("rsmode." + this.tile.getRSMode().toString().toLowerCase())));
            for (int i = 0; i < 3; ++i) {
                this.addLine("rsmode", i, this.tile.getRSMode().toString(), tooltip);
            }
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY) {
        if (mouseX >= 177 && mouseX <= 192 && mouseY >= 76 && mouseY <= 92) {
            PacketHandler.sendToServer(new PacketClick(this.x, this.y, this.z, -777));
        }
    }

    @Override
    public void draw(GuiMariculture gui, int x, int y, int mouseX, int mouseY) {
        super.draw(gui, x, y, mouseX, mouseY);
        int offsetY = mouseX >= 177 && mouseX <= 192 && mouseY >= 76 && mouseY <= 92 ? -18 : 0;
        int color = 0xA62A2A;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
        gui.func_73729_b(x + 175, y + 73, 176, 122, 21, 22);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (this.tile.getRSMode()) {
            case DISABLED: {
                gui.func_73729_b(x + 177, y + 76, 199, 125 + offsetY, 16, 16);
                break;
            }
            case LOW: {
                gui.func_73729_b(x + 177, y + 76, 219, 125 + offsetY, 16, 16);
                break;
            }
            case HIGH: {
                gui.func_73729_b(x + 177, y + 76, 239, 125 + offsetY, 16, 16);
                break;
            }
            default: {
                gui.func_73729_b(x + 177, y + 76, 219, 125 + offsetY, 16, 16);
            }
        }
    }

    public static enum RedstoneMode {
        DISABLED,
        LOW,
        HIGH;


        public static RedstoneMode readFromNBT(NBTTagCompound nbt) {
            return RedstoneMode.values()[nbt.func_74771_c("RedstoneMode")];
        }

        public static void writeToNBT(NBTTagCompound nbt, RedstoneMode mode) {
            nbt.func_74774_a("RedstoneMode", (byte)mode.ordinal());
        }

        public static boolean canWork(TileEntity tile, RedstoneMode mode) {
            switch (mode) {
                case DISABLED: {
                    return true;
                }
                case LOW: {
                    return !tile.func_145831_w().func_72864_z(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
                }
                case HIGH: {
                    return tile.func_145831_w().func_72864_z(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
                }
            }
            return !tile.func_145831_w().func_72864_z(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        }

        public static RedstoneMode toggle(RedstoneMode mode) {
            switch (mode) {
                case DISABLED: {
                    return LOW;
                }
                case LOW: {
                    return HIGH;
                }
                case HIGH: {
                    return DISABLED;
                }
            }
            return mode;
        }
    }
}

