/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.handlers;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import mariculture.core.Core;
import mariculture.core.config.WorldGeneration;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenRiver;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;

public class WorldEventHandler {
    private static double[] noiseValue = new double[256];
    private static NoiseGeneratorPerlin noiseGenerator = null;

    public static boolean isBlacklisted(int i) {
        for (int j : WorldGeneration.WorldGen.OCEAN_BLACKLIST) {
            if (i != j) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onReplaceBiomeBlocks(ChunkProviderEvent.ReplaceBiomeBlocks event) {
        IChunkProvider chunkProvider;
        if (event.metaArray == null || event.world == null || WorldEventHandler.isBlacklisted(event.world.field_73011_w.field_76574_g)) {
            return;
        }
        if (noiseGenerator == null) {
            noiseGenerator = new NoiseGeneratorPerlin(event.world.field_73012_v, 4);
        }
        if ((chunkProvider = event.world.func_72863_F()) instanceof ChunkProviderServer) {
            ChunkProviderServer chunk = (ChunkProviderServer)chunkProvider;
            noiseValue = noiseGenerator.func_151599_a(noiseValue, (double)(event.chunkX * 16), (double)(event.chunkZ * 16), 16, 16, 0.0625, 0.0625, 1.0);
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    BiomeGenBase biome = event.biomeArray[l + k * 16];
                    if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                        if (WorldGeneration.WorldGen.VARYING_LIMESTONE) {
                            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                                this.genBiomeTerrain(event, k, l, biome, WorldGeneration.WorldGen.BEACH_LIMESTONE);
                                continue;
                            }
                            if (biome == BiomeGenBase.field_150575_M) {
                                this.genBiomeTerrain(event, k, l, biome, WorldGeneration.WorldGen.OCEAN_DEEP_LIMESTONE);
                                continue;
                            }
                            if (biome instanceof BiomeGenRiver) {
                                this.genBiomeTerrain(event, k, l, biome, WorldGeneration.WorldGen.RIVER_LIMESTONE);
                                continue;
                            }
                            this.genBiomeTerrain(event, k, l, biome, WorldGeneration.WorldGen.OCEAN_LIMESTONE);
                            continue;
                        }
                        this.genBiomeTerrain(event, k, l, biome, WorldGeneration.WorldGen.OCEAN_LIMESTONE);
                        continue;
                    }
                    biome.func_150573_a(event.world, event.world.field_73012_v, event.blockArray, event.metaArray, event.chunkX * 16 + k, event.chunkZ * 16 + l, noiseValue[l + k * 16]);
                }
            }
            event.setResult(Event.Result.DENY);
        }
    }

    private void genBiomeTerrain(ChunkProviderEvent.ReplaceBiomeBlocks event, int k, int l, BiomeGenBase biome, double depth) {
        WorldEventHandler.genBiomeTerrain(event.world, event.world.field_73012_v, event.blockArray, event.metaArray, event.chunkX * 16 + k, event.chunkZ * 16 + l, noiseValue[l + k * 16], biome, WorldGeneration.WorldGen.OCEAN_LIMESTONE);
    }

    public static final void genBiomeTerrain(World world, Random rand, Block[] blocksArray, byte[] metaArray, int x, int z, double noise, BiomeGenBase biome, double depth) {
        Block seabed = WorldGeneration.WorldGen.LIMESTONE_FLOOR ? Core.limestone : Blocks.field_150322_A;
        BlockGrass topBlock = Blocks.field_150349_c;
        Block fillerBlock = Blocks.field_150346_d;
        boolean flag = true;
        BlockGrass block = topBlock;
        byte b0 = 0;
        Block block1 = fillerBlock;
        int k = -1;
        int l = (int)(noise / depth + depth + rand.nextDouble() * 0.25);
        int i1 = x & 0xF;
        int j1 = z & 0xF;
        int k1 = blocksArray.length / 256;
        for (int l1 = 255; l1 >= 0; --l1) {
            int i2 = (j1 * 16 + i1) * k1 + l1;
            if (l1 <= 0 + rand.nextInt(5)) {
                blocksArray[i2] = Blocks.field_150357_h;
                continue;
            }
            Block block2 = blocksArray[i2];
            if (block2 != null && block2.func_149688_o() != Material.field_151579_a) {
                int chance;
                if (block2 != Blocks.field_150348_b) continue;
                if (k == -1) {
                    if (l <= 0) {
                        block = null;
                        b0 = 0;
                        block1 = Blocks.field_150348_b;
                    } else if (l1 >= 59 && l1 <= 64) {
                        block = topBlock;
                        b0 = 0;
                        block1 = fillerBlock;
                    }
                    if (l1 < 63 && (block == null || block.func_149688_o() == Material.field_151579_a)) {
                        if (biome.func_150564_a(x, l1, z) < 0.15f) {
                            block = Blocks.field_150432_aD;
                            b0 = 0;
                        } else {
                            block = Blocks.field_150355_j;
                            b0 = 0;
                        }
                    }
                    k = l;
                    if (l1 >= 62) {
                        blocksArray[i2] = block;
                        metaArray[i2] = b0;
                        continue;
                    }
                    if (l1 < 61 - l) {
                        block = null;
                        block1 = seabed;
                        blocksArray[i2] = Blocks.field_150354_m;
                        continue;
                    }
                    blocksArray[i2] = block1;
                    continue;
                }
                if (k <= 0) continue;
                --k;
                int n = chance = biome instanceof BiomeGenRiver ? WorldGeneration.OreGen.RUTILE_SPAWN_CHANCE / 2 : WorldGeneration.OreGen.RUTILE_SPAWN_CHANCE;
                if (block1 == seabed && WorldGeneration.OreGen.RUTILE_ON && world.field_73012_v.nextInt(chance) == 0) {
                    blocksArray[i2] = Core.rocks;
                    metaArray[i2] = 3;
                } else {
                    blocksArray[i2] = block1;
                }
                if (k != 0 || block1 != Blocks.field_150354_m) continue;
                k = rand.nextInt(4) + Math.max(0, l1 - 63);
                block1 = Blocks.field_150322_A;
                continue;
            }
            k = -1;
        }
    }
}

