/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.handlers;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.Core;
import mariculture.core.config.WorldGeneration;
import mariculture.core.handlers.PearlGenHandler;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.tile.TileOyster;
import mariculture.core.world.WorldGenGas;
import mariculture.core.world.WorldGenOre;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenHandler
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                break;
            }
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
            case 1: {
                break;
            }
            default: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateSurface(World world, Random random, int x, int z) {
        WorldGenHandler.generateGas(world, random, x, z);
        WorldGenHandler.generateBauxite(world, random, x, z);
        WorldGenHandler.generateCopper(world, random, x, z);
        WorldGenHandler.generateOyster(world, random, x, z);
    }

    public static void generateBauxite(World world, Random random, int x, int z) {
        if (WorldGeneration.OreGen.BAUXITE_ON) {
            for (int i = 0; i < WorldGeneration.OreGen.BAUXITE_TOTAL; ++i) {
                int posX = x + random.nextInt(16);
                int posY = WorldGeneration.OreGen.BAUXITE_MIN + random.nextInt(WorldGeneration.OreGen.BAUXITE_MAX - WorldGeneration.OreGen.BAUXITE_MIN);
                int posZ = z + random.nextInt(16);
                new WorldGenOre(Core.rocks, 2, WorldGeneration.OreGen.BAUXITE_VEIN, Blocks.field_150348_b).func_76484_a(world, random, posX, posY, posZ);
            }
        }
    }

    public static void generateGas(World world, Random random, int x, int z) {
        if (WorldGeneration.OreGen.NATURAL_GAS_ON && random.nextInt(WorldGeneration.OreGen.NATURAL_GAS_CHANCE) == 0 && MaricultureHandlers.environment.getSalinity(world, x, z) == Environment.Salinity.SALINE) {
            int posX = x + random.nextInt(16);
            int posY = WorldGeneration.OreGen.NATURAL_GAS_MIN + random.nextInt(WorldGeneration.OreGen.NATURAL_GAS_MAX - WorldGeneration.OreGen.NATURAL_GAS_MIN);
            int posZ = z + random.nextInt(16);
            new WorldGenGas(Core.air, 0, WorldGeneration.OreGen.NATURAL_GAS_VEIN, Blocks.field_150348_b).func_76484_a(world, random, posX, posY, posZ);
        }
    }

    public static void generateCopper(World world, Random random, int x, int z) {
        if (WorldGeneration.OreGen.COPPER_ON) {
            for (int i = 0; i < WorldGeneration.OreGen.COPPER_TOTAL; ++i) {
                int posX = x + random.nextInt(16);
                int posY = WorldGeneration.OreGen.COPPER_MIN + random.nextInt(WorldGeneration.OreGen.COPPER_MAX - WorldGeneration.OreGen.COPPER_MIN);
                int posZ = z + random.nextInt(16);
                new WorldGenOre(Core.rocks, 1, WorldGeneration.OreGen.COPPER_VEIN, Blocks.field_150348_b).func_76484_a(world, random, posX, posY, posZ);
            }
        }
    }

    public static void generateOyster(World world, Random random, int x, int z) {
        if (WorldGeneration.WorldGen.OYSTER_ENABLED) {
            for (int j = 0; j < WorldGeneration.WorldGen.OYSTER_PER_CHUNK; ++j) {
                int chance = WorldGeneration.WorldGen.OYSTER_CHANCE;
                if (random.nextInt(Math.max(1, chance)) != 0) continue;
                int randMeta = random.nextInt(4);
                int randX = x - 8 + random.nextInt(4);
                int randZ = z - 8 + random.nextInt(4);
                int blockY = world.func_72825_h(randX, randZ);
                if (MaricultureHandlers.environment.getSalinity(world, randX, randZ) != Environment.Salinity.SALINE || !Core.water.func_149718_j(world, randX, blockY, randZ) || !BlockHelper.isWater(world, randX, blockY + 1, randZ)) continue;
                world.func_147449_b(randX, blockY, randZ, Core.water);
                TileOyster oyster = (TileOyster)world.func_147438_o(randX, blockY, randZ);
                if (oyster == null) continue;
                oyster.orientation = ForgeDirection.values()[2 + random.nextInt(4)];
                if (random.nextInt(WorldGeneration.WorldGen.OYSTER_PEARL_CHANCE) != 0) continue;
                oyster.func_70299_a(0, PearlGenHandler.getRandomPearl(random));
            }
        }
    }
}

