/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers;

import java.util.LinkedHashMap;
import java.util.Map;
import mariculture.api.core.MaricultureHandlers;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class EnchantHelper {
    public static int MAX_WEIGHT = 0;

    public static boolean exists(Enchantment enchant) {
        if (enchant == null) {
            return false;
        }
        return enchant.field_77352_x > 0;
    }

    public static int getEnchantStrength(Enchantment enchant, EntityPlayer player) {
        if (!EnchantHelper.exists(enchant)) {
            return 0;
        }
        return MaricultureHandlers.mirror.getEnchantmentStrength(player, enchant.field_77352_x);
    }

    public static boolean hasEnchantment(Enchantment enchant, EntityPlayer player) {
        return EnchantHelper.getEnchantStrength(enchant, player) > 0;
    }

    public static void damageItems(Enchantment enchant, EntityPlayer player, int dmg) {
        if (!EnchantHelper.exists(enchant) || player.field_71075_bZ.field_75098_d) {
            return;
        }
        MaricultureHandlers.mirror.damageItemsWithEnchantment(player, enchant.field_77352_x, dmg);
    }

    public static int getLevel(Enchantment enchant, ItemStack stack) {
        if (!EnchantHelper.exists(enchant)) {
            return 0;
        }
        if (EnchantHelper.isBroken(stack)) {
            return 0;
        }
        return EnchantmentHelper.func_77506_a((int)enchant.field_77352_x, (ItemStack)stack);
    }

    public static int getLevel(int id, ItemStack stack) {
        return EnchantHelper.getLevel(EnchantHelper.getEnchant(id), stack);
    }

    public static boolean hasEnchantment(Enchantment enchant, ItemStack stack) {
        return EnchantHelper.getLevel(enchant, stack) > 0;
    }

    public static boolean hasEnchantment(int id, ItemStack stack) {
        return EnchantHelper.hasEnchantment(EnchantHelper.getEnchant(id), stack);
    }

    public static Enchantment getEnchant(int id) {
        return Enchantment.field_77331_b[id];
    }

    public static boolean isBroken(ItemStack stack) {
        return stack != null && stack.func_77960_j() >= stack.func_77958_k();
    }

    public static int getEnchantmentValue(ItemStack stack) {
        if (MAX_WEIGHT == 0) {
            EnchantHelper.setMax();
        }
        int volume = 0;
        LinkedHashMap maps = (LinkedHashMap)EnchantmentHelper.func_82781_a((ItemStack)stack);
        for (Map.Entry i : maps.entrySet()) {
            Enchantment enchant = Enchantment.field_77331_b[(Integer)i.getKey()];
            volume += (Integer)i.getValue() * (MAX_WEIGHT + 1 - enchant.func_77324_c());
        }
        return (int)Math.max(1.0, (double)volume / (double)MAX_WEIGHT * 5.0 * 5.0);
    }

    public static void setMax() {
        for (Enchantment enchant : Enchantment.field_77331_b) {
            if (enchant == null || enchant.func_77324_c() <= MAX_WEIGHT) continue;
            MAX_WEIGHT = enchant.func_77324_c();
        }
    }
}

