/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.items;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.MaricultureTab;
import mariculture.api.util.Text;
import mariculture.core.config.GeneralStuff;
import mariculture.core.helpers.ClientHelper;
import mariculture.core.items.ItemMariculture;
import mariculture.core.lib.Modules;
import mariculture.world.WorldPlus;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemCrafting
extends ItemMariculture
implements IEnergyContainerItem {
    @Override
    public int getMetaCount() {
        return 24;
    }

    @Override
    public String getName(ItemStack stack) {
        String name = "";
        switch (stack.func_77960_j()) {
            case 0: {
                return "goldenSilk";
            }
            case 1: {
                return "goldenThread";
            }
            case 3: {
                return "polishedStick";
            }
            case 4: {
                return "neoprene";
            }
            case 5: {
                return "plastic";
            }
            case 6: {
                return "scubaLens";
            }
            case 7: {
                return "aluminumSheet";
            }
            case 8: {
                return "heater";
            }
            case 9: {
                return "cooler";
            }
            case 10: {
                return "carbide";
            }
            case 11: {
                return "wheel";
            }
            case 12: {
                return "wicker";
            }
            case 13: {
                return "plasticYellow";
            }
            case 15: {
                return "dragonEgg";
            }
            case 2: {
                return "titaniumRod";
            }
            case 16: {
                return "plan_blank";
            }
            case 17: {
                return "titaniumSheet";
            }
            case 18: {
                return "snorkelLens";
            }
            case 14: {
                return "burntBrick";
            }
            case 19: {
                return "titaniumRodBasic";
            }
            case 20: {
                return "lifeCore";
            }
            case 21: {
                return "kelpSeeds";
            }
            case 22: {
                return "batteryCreative";
            }
            case 23: {
                return "thermometer";
            }
        }
        return "unnamed";
    }

    public boolean spawnEnderDragon(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return true;
        }
        EntityDragon dragon = new EntityDragon(world);
        dragon.func_70107_b(player.field_70165_t, player.field_70163_u + 10.0, player.field_70161_v);
        world.func_72838_d((Entity)dragon);
        --stack.field_77994_a;
        return true;
    }

    private void displayTemperature(boolean isSneaking, World world, int x, int y, int z) {
        if (world.field_72995_K) {
            String prefix = "";
            int temperature = 0;
            if (isSneaking) {
                prefix = Text.translate("temperature.generic");
                temperature = MaricultureHandlers.environment.getBiomeTemperature(world, x, y, z);
            } else {
                prefix = Text.translate("temperature.precise");
                temperature = MaricultureHandlers.environment.getTemperature(world, x, y, z);
            }
            if (world.func_72935_r()) {
                ClientHelper.addToChat(Text.translate("time") + " " + Text.translate("time.day"));
            } else {
                ClientHelper.addToChat(Text.translate("time") + " " + Text.translate("time.night"));
            }
            ClientHelper.addToChat(prefix + ": " + temperature + "\u00b0C");
            ClientHelper.addToChat(Text.translate("environment.salinity") + ": " + Text.translate("salinity." + MaricultureHandlers.environment.getSalinity(world, x, z).name().toLowerCase()));
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        int dmg = stack.func_77960_j();
        if (dmg == 15 && GeneralStuff.ENABLE_ENDER_SPAWN) {
            return this.spawnEnderDragon(stack, player, world, x, y, z);
        }
        if (dmg == 23) {
            this.displayTemperature(player.func_70093_af(), world, x, y, z);
        } else if (Modules.isActive(Modules.worldplus) && dmg == 21 && Item.func_150898_a((Block)WorldPlus.plantGrowable).func_77648_a(new ItemStack(WorldPlus.plantGrowable), player, world, x, y, z, side, par8, par9, par10)) {
            --stack.field_77994_a;
        }
        return true;
    }

    @Override
    public boolean isActive(int meta) {
        switch (meta) {
            case 15: {
                return Modules.isActive(Modules.fishery);
            }
            case 16: {
                return Modules.isActive(Modules.factory);
            }
            case 3: {
                return Modules.isActive(Modules.fishery);
            }
            case 2: {
                return Modules.isActive(Modules.fishery);
            }
        }
        return true;
    }

    private boolean isValidTab(CreativeTabs creative, int meta) {
        if (meta == 16) {
            return creative == MaricultureTab.tabFactory;
        }
        if (meta == 21) {
            return creative == MaricultureTab.tabWorld;
        }
        if (meta == 23) {
            return creative == MaricultureTab.tabFishery;
        }
        return creative == MaricultureTab.tabCore;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creative, List list) {
        for (int meta = 0; meta < this.getMetaCount(); ++meta) {
            if (!this.isActive(meta) || !this.isValidTab(creative, meta)) continue;
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{MaricultureTab.tabCore, MaricultureTab.tabFactory, MaricultureTab.tabFishery, MaricultureTab.tabWorld};
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return container.func_77960_j() == 22 ? 10000000 : 0;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return 0;
    }
}

