/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mariculture.api.core.MaricultureRegistry;
import mariculture.api.core.MaricultureTab;
import mariculture.core.Core;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.network.PacketHandler;
import mariculture.core.util.IItemRegistry;
import mariculture.core.util.ITank;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemFluidStorage
extends Item
implements IFluidContainerItem,
IItemRegistry {
    public int capacity;
    private IIcon filledIcon;

    public ItemFluidStorage(int capacity) {
        this.capacity = capacity;
        this.func_77637_a(MaricultureTab.tabFactory);
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, true);
        if (movingobjectposition == null) {
            return item;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            IFluidContainerItem container = (IFluidContainerItem)item.func_77973_b();
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            int side = movingobjectposition.field_72310_e;
            Block block = world.func_147439_a(x, y, z);
            if (block instanceof BlockFluidBase || block instanceof BlockLiquid) {
                FluidStack fluid = null;
                if (block instanceof BlockFluidBase) {
                    fluid = ((BlockFluidBase)block).drain(world, x, y, z, false);
                }
                if (BlockHelper.isWater(world, x, y, z)) {
                    fluid = FluidRegistry.getFluidStack((String)"water", (int)1000);
                }
                if (BlockHelper.isLava(world, x, y, z)) {
                    fluid = FluidRegistry.getFluidStack((String)"lava", (int)1000);
                }
                if (fluid != null && container.fill(item, fluid, false) >= fluid.amount) {
                    if (block instanceof BlockFluidBase) {
                        ((BlockFluidBase)block).drain(world, x, y, z, true);
                    } else {
                        world.func_147468_f(x, y, z);
                    }
                    container.fill(item, fluid, true);
                    return item;
                }
            }
            if (((IFluidContainerItem)item.func_77973_b()).getFluid(item) != null) {
                FluidStack stack = ((IFluidContainerItem)item.func_77973_b()).getFluid(item);
                Fluid fluid = stack.getFluid();
                if (!fluid.canBePlacedInWorld()) {
                    return item;
                }
                int drain = FluidHelper.getRequiredVolumeForBlock(fluid);
                FluidStack result = ((IFluidContainerItem)item.func_77973_b()).drain(item, drain, false);
                if (result == null || result.amount < drain) {
                    return item;
                }
                if (!result.getFluid().getName().equals("lava") && world.field_73011_w.field_76575_d) {
                    return item;
                }
                if (side == 1 && (block instanceof BlockFluidBase || block instanceof BlockLiquid)) {
                    --y;
                } else if (block == Blocks.field_150431_aC && (world.func_72805_g(x, y, z) & 7) < 1) {
                    side = 1;
                } else if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I) {
                    if (side == 0) {
                        --y;
                    }
                    if (side == 1) {
                        ++y;
                    }
                    if (side == 2) {
                        --z;
                    }
                    if (side == 3) {
                        ++z;
                    }
                    if (side == 4) {
                        --x;
                    }
                    if (side == 5) {
                        ++x;
                    }
                }
                if (!player.func_82247_a(x, y, z, side, item)) {
                    return item;
                }
                if (item.field_77994_a == 0) {
                    return item;
                }
                Block theBlock = fluid.getBlock();
                if (world.func_147465_d(x, y, z, theBlock, 0, 2)) {
                    if (world.func_147439_a(x, y, z) == theBlock) {
                        theBlock.func_149689_a(world, x, y, z, (EntityLivingBase)player, item);
                        theBlock.func_149714_e(world, x, y, z, 0);
                    }
                    world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), theBlock.field_149762_H.func_150496_b(), (theBlock.field_149762_H.func_150497_c() + 1.0f) / 2.0f, theBlock.field_149762_H.func_150494_d() * 0.8f);
                    ((IFluidContainerItem)item.func_77973_b()).drain(item, drain, true);
                    return item;
                }
            }
        }
        return item;
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (FluidHelper.isIContainer(item) && world.func_147438_o(x, y, z) instanceof IFluidHandler) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            IFluidHandler tank = (IFluidHandler)world.func_147438_o(x, y, z);
            IFluidContainerItem container = (IFluidContainerItem)item.func_77973_b();
            FluidStack fluid = container.getFluid(item);
            if (fluid != null && fluid.amount > 0) {
                FluidStack stack = container.drain(item, 1000000, false);
                if (stack != null) {
                    stack.amount = tank.fill(dir, stack, false);
                    if (stack.amount > 0) {
                        container.drain(item, stack.amount, true);
                        tank.fill(dir, stack, true);
                        if (tank instanceof ITank) {
                            PacketHandler.syncFluids(world.func_147438_o(x, y, z), ((ITank)tank).getFluid());
                        }
                        return true;
                    }
                }
            } else {
                FluidStack stack = tank.drain(dir, this.capacity, false);
                if (stack != null && stack.amount > 0) {
                    tank.drain(dir, stack.amount, true);
                    container.fill(item, stack, true);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    public String func_77653_i(ItemStack stack) {
        return "\u00a76" + ("" + StatCollector.func_74838_a((String)(this.func_77657_g(stack) + ".name"))).trim();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        FluidStack fluid = this.getFluid(stack);
        int amount = fluid == null ? 0 : fluid.amount;
        list.add(FluidHelper.getFluidName(fluid));
        list.add("" + amount + "/" + this.capacity + "mB");
    }

    public boolean func_77623_v() {
        return true;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (stack.func_77973_b() == Core.bucketTitanium) {
            if (pass == 0) {
                if (stack.func_77942_o() && this.getFluid(stack) != null) {
                    FluidStack fake = this.getFluid(stack).copy();
                    fake.amount = Short.MAX_VALUE;
                    ItemStack bucket = FluidContainerRegistry.fillFluidContainer((FluidStack)fake, (ItemStack)new ItemStack(Items.field_151133_ar));
                    if (bucket != null) {
                        return bucket.func_77954_c();
                    }
                }
                return this.field_77791_bV;
            }
            return this.filledIcon;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        String name = this.getName(new ItemStack((Item)this));
        String[] aName = name.split("\\.");
        String theName = aName.length >= 2 ? aName[0] + aName[1].substring(0, 1).toUpperCase() + aName[1].substring(1) : name;
        this.field_77791_bV = iconRegister.func_94245_a("mariculture:" + theName);
        if (this == Core.bucketTitanium) {
            this.filledIcon = iconRegister.func_94245_a("mariculture:" + theName + "Filled");
        }
    }

    public int getCapacity(ItemStack stack) {
        return this.capacity;
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        int filled;
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
                return Math.min(this.capacity, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
            if (stack == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource) && stack.amount > 0) {
                return 0;
            }
            return Math.min(this.capacity - stack.amount, resource.amount);
        }
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        if (!container.field_77990_d.func_74764_b("Fluid")) {
            NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
            if (this.capacity < resource.amount) {
                fluidTag.func_74768_a("Amount", this.capacity);
                container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
                return this.capacity;
            }
            container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
            return resource.amount;
        }
        NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (!stack.isFluidEqual(resource) && stack.amount > 0) {
            return 0;
        }
        if (!stack.isFluidEqual(resource)) {
            stack.fluidID = resource.fluidID;
        }
        if (resource.amount < (filled = this.capacity - stack.amount)) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = this.capacity;
        }
        container.field_77990_d.func_74782_a("Fluid", (NBTBase)stack.writeToNBT(fluidTag));
        return filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
        if (stack == null) {
            return null;
        }
        stack.amount = Math.min(stack.amount, maxDrain);
        if (doDrain) {
            NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("Fluid");
            int newAmount = fluidTag.func_74762_e("Amount") - stack.amount;
            if (newAmount == 0) {
                container.func_77982_d(null);
                return stack;
            }
            fluidTag.func_74768_a("Amount", newAmount);
            container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        return stack;
    }

    @Override
    public void register(Item item) {
        MaricultureRegistry.register(this.getName(new ItemStack(item, 1, 0)), new ItemStack(item, 1, 0));
    }

    @Override
    public int getMetaCount() {
        return 1;
    }

    @Override
    public String getName(ItemStack stack) {
        return this.func_77658_a().substring(5);
    }
}

