/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mariculture.core.helpers.ClientHelper;
import mariculture.core.network.PacketCoords;
import mariculture.core.tile.base.TileMultiBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketMultiInit
extends PacketCoords
implements IMessageHandler<PacketMultiInit, IMessage> {
    public int mX;
    public int mY;
    public int mZ;
    public int facing;

    public PacketMultiInit() {
    }

    public PacketMultiInit(int x, int y, int z, int mX, int mY, int mZ, ForgeDirection facing) {
        super(x, y, z);
        this.mX = mX;
        this.mY = mY;
        this.mZ = mZ;
        this.facing = facing.ordinal();
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.mX);
        buffer.writeInt(this.mY);
        buffer.writeInt(this.mZ);
        buffer.writeInt(this.facing);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.mX = buffer.readInt();
        this.mY = buffer.readInt();
        this.mZ = buffer.readInt();
        this.facing = buffer.readInt();
    }

    public IMessage onMessage(PacketMultiInit message, MessageContext ctx) {
        TileEntity te = ClientHelper.getPlayer().field_70170_p.func_147438_o(message.x, message.y, message.z);
        if (te instanceof TileMultiBlock) {
            if (message.mY < 0) {
                ((TileMultiBlock)te).setMaster(null);
            } else {
                ((TileMultiBlock)te).setMaster(new TileMultiBlock.MultiPart(message.mX, message.mY, message.mZ));
            }
            ((TileMultiBlock)te).setFacing(ForgeDirection.values()[message.facing]);
            ClientHelper.updateRender(message.x, message.y, message.z);
        }
        return null;
    }
}

