/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.render;

import mariculture.core.tile.base.TileMultiBlock;
import mariculture.core.util.IFaceable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public abstract class RenderBase {
    private static final double RENDER_OFFSET = (double)0.001f;
    static final float LIGHT_Y_POS = 1.0f;
    public RenderBlocks render;
    public ForgeDirection dir = ForgeDirection.UNKNOWN;
    public IBlockAccess world;
    public int x;
    public int y;
    public int z;
    public IIcon icon;
    public Block block;
    public boolean isItem;
    public int brightness = -1;
    public float rgb_red = 1.0f;
    public float rgb_green = 1.0f;
    public float rgb_blue = 1.0f;

    public boolean render(RenderBlocks render, IBlockAccess world, int x, int y, int z) {
        this.isItem = false;
        this.render = render;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.block = world.func_147439_a(x, y, z);
        this.init();
        this.render();
        return true;
    }

    public void render(RenderBlocks render, Block block) {
        this.isItem = true;
        this.render = render;
        this.block = block;
        this.render();
    }

    public boolean render() {
        if (this.isItem()) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.4f, (float)-0.5f);
            GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
            this.renderBlock();
            GL11.glPopMatrix();
        } else {
            this.renderBlock();
            if (this.render.func_147744_b()) {
                this.render.func_147771_a();
            }
        }
        return true;
    }

    public abstract void renderBlock();

    public void init() {
        if (this.world.func_147438_o(this.x, this.y, this.z) instanceof IFaceable) {
            this.dir = ((IFaceable)this.world.func_147438_o(this.x, this.y, this.z)).getFacing();
        }
        if (this.world.func_147438_o(this.x, this.y, this.z) instanceof TileMultiBlock) {
            this.dir = ((TileMultiBlock)this.world.func_147438_o((int)this.x, (int)this.y, (int)this.z)).facing;
        }
    }

    public boolean isItem() {
        return this.isItem;
    }

    protected void setTexture(IIcon texture) {
        this.icon = texture;
        if (!this.isItem()) {
            this.render.func_147757_a(texture);
        }
    }

    protected void setTexture(ItemStack stack) {
        this.setTexture(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j());
    }

    protected void setTexture(Block block, int meta) {
        this.setTexture(block.func_149691_a(0, meta));
    }

    protected void setTexture(Block block) {
        this.setTexture(block, 0);
    }

    protected void renderColoredBlock(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Block block) {
        this.render.field_147837_f = true;
        this.render.func_147782_a(minX, minY, minZ, maxX, maxY, maxZ);
        this.render.func_147784_q(block, this.x, this.y, this.z);
        this.render.field_147837_f = false;
    }

    protected void renderBlock(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (this.isItem()) {
            this.renderItemBlock(minX, minY, minZ, maxX, maxY, maxZ);
        } else {
            this.renderWorldBlock(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    private void renderFace(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon iicon = this.icon;
        if (!this.isItem()) {
            tessellator.func_78380_c(this.block.func_149677_c(this.world, this.x, this.y, this.z));
        }
        if (this.brightness > -1) {
            tessellator.func_78380_c(this.brightness);
        }
        tessellator.func_78386_a(this.rgb_red, this.rgb_green, this.rgb_blue);
        double d0 = iicon.func_94209_e();
        double d1 = iicon.func_94206_g();
        double d2 = iicon.func_94212_f();
        double d3 = iicon.func_94210_h();
        double d4 = 0.0625;
        double d5 = (double)(this.x + 1) + x1;
        double d6 = (double)(this.x + 1) + x2;
        double d7 = (double)(this.x + 0) + x3;
        double d8 = (double)(this.x + 0) + x4;
        double d9 = (double)(this.z + 0) + z1;
        double d10 = (double)(this.z + 1) + z2;
        double d11 = (double)(this.z + 1) + z3;
        double d12 = (double)(this.z + 0) + z4;
        double d13 = (double)this.y + d4 + y1;
        double d14 = (double)this.y + d4 + y2;
        double d15 = (double)this.y + d4 + y3;
        double d16 = (double)this.y + d4 + y4;
        tessellator.func_78374_a(d5, d13, d9, d2, d1);
        tessellator.func_78374_a(d6, d14, d10, d2, d3);
        tessellator.func_78374_a(d7, d15, d11, d0, d3);
        tessellator.func_78374_a(d8, d16, d12, d0, d1);
        tessellator.func_78374_a(d8, d16, d12, d0, d1);
        tessellator.func_78374_a(d7, d15, d11, d0, d3);
        tessellator.func_78374_a(d6, d14, d10, d2, d3);
        tessellator.func_78374_a(d5, d13, d9, d2, d1);
    }

    protected void renderFluid(FluidStack fluid, int max, double scale, int xPlus, int yPlus, int zPlus) {
        int x2 = this.x + xPlus;
        int y2 = this.y + yPlus;
        int z2 = this.z + zPlus;
        Tessellator tessellator = Tessellator.field_78398_a;
        int color = this.block.func_149720_d(this.world, x2, y2, z2);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        double extra = (double)fluid.amount / (double)max * scale;
        double height = 0.4 + extra;
        IIcon iconStill = fluid.getFluid().getIcon();
        height += (double)0.001f;
        double u2 = iconStill.func_94214_a(0.0);
        double v2 = iconStill.func_94207_b(0.0);
        double u1 = u2;
        double v1 = iconStill.func_94207_b(16.0);
        double u4 = iconStill.func_94214_a(16.0);
        double v4 = v1;
        double u3 = u4;
        double v3 = v2;
        tessellator.func_78380_c(200);
        tessellator.func_78386_a(1.0f * red, 1.0f * green, 1.0f * blue);
        tessellator.func_78374_a((double)(x2 + 0), (double)y2 + height, (double)(z2 + 0), u2, v2);
        tessellator.func_78374_a((double)(x2 + 0), (double)y2 + height, (double)(z2 + 1), u1, v1);
        tessellator.func_78374_a((double)(x2 + 1), (double)y2 + height, (double)(z2 + 1), u4, v4);
        tessellator.func_78374_a((double)(x2 + 1), (double)y2 + height, (double)(z2 + 0), u3, v3);
        this.render.field_147855_j = 0.0;
        this.render.field_147857_k = 1.0;
    }

    protected void renderFluidBlock(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.render.field_147837_f = true;
        this.render.func_147782_a(minX, minY, minZ, maxX, maxY, maxZ);
        this.render.func_147784_q(Blocks.field_150353_l, this.x, this.y, this.z);
        this.render.field_147837_f = false;
    }

    private void renderWorldBlock(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.render.field_147837_f = true;
        this.render.func_147782_a(minX, minY, minZ, maxX, maxY, maxZ);
        this.render.func_147784_q(this.block, this.x, this.y, this.z);
        this.render.field_147837_f = false;
    }

    protected void renderAngledBlock(double x2, double y2, double z2, double x3, double y3, double z3, double x1, double y1, double z1, double x4, double y4, double z4) {
        this.renderAngledBlock(x2, y2, z2, x3, y3, z3, x1, y1, z1, x4, y4, z4, 0.0, 0.0, 0.0);
    }

    protected void renderAngledBlock(double x2, double y2, double z2, double x3, double y3, double z3, double x1, double y1, double z1, double x4, double y4, double z4, double xDim, double height, double zDim) {
        if (this.icon == null) {
            return;
        }
        this.renderFace(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
        this.renderFace(x1, y1 + height, z1, x2, y2 + height, z2, x3, y3 + height, z3, x4, y4 + height, z4);
        this.renderFace(x1, y1, z1, x2, y2, z2, x2 + 1.0, y2 + height, z2, x1 + 1.0, y1 + height, z1);
        this.renderFace(x4 - 1.0, y4, z4, x3 - 1.0, y3, z3, x3, y3 + height, z3, x4, y4 + height, z4);
        this.renderFace(x1, y1, z1, x1, y1 + height, z1 - 1.0, x4, y4 + height, z4 - 1.0, x4, y4, z4);
        this.renderFace(x2, y2, z2 + 1.0, x2, y2 + height, z2, x3, y3 + height, z3, x3, y3, z3 + 1.0);
    }

    private void renderItemBlock(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (this.icon == null) {
            return;
        }
        this.render.field_147859_h = minX;
        this.render.field_147855_j = minY;
        this.render.field_147851_l = minZ;
        this.render.field_147861_i = maxX;
        this.render.field_147857_k = maxY;
        this.render.field_147853_m = maxZ;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        this.render.func_147768_a(this.block, 0.0, 0.0, 0.0, this.icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        this.render.func_147806_b(this.block, 0.0, 0.0, 0.0, this.icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        this.render.func_147761_c(this.block, 0.0, 0.0, 0.0, this.icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        this.render.func_147734_d(this.block, 0.0, 0.0, 0.0, this.icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.render.func_147798_e(this.block, 0.0, 0.0, 0.0, this.icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.render.func_147764_f(this.block, 0.0, 0.0, 0.0, this.icon);
        tessellator.func_78381_a();
    }
}

