/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import java.util.List;
import java.util.Random;
import mariculture.core.Core;
import mariculture.core.config.Machines;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.BlockTransferHelper;
import mariculture.core.helpers.PlayerHelper;
import mariculture.core.lib.ArmorSlot;
import mariculture.core.lib.Modules;
import mariculture.core.network.PacketAirPump;
import mariculture.core.network.PacketHandler;
import mariculture.core.tile.base.TileStorageTank;
import mariculture.core.util.Fluids;
import mariculture.core.util.IFaceable;
import mariculture.core.util.Tank;
import mariculture.diving.Diving;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAirPump
extends TileStorageTank
implements IEnergyHandler,
IFaceable {
    protected BlockTransferHelper helper;
    protected EnergyStorage storage = new EnergyStorage(100);
    public ForgeDirection orientation = ForgeDirection.WEST;
    public boolean animate;
    private double wheelAngle1 = 0.0;
    private double wheelAngle2 = 0.0;
    private Random rand = new Random();
    private int tick;
    public boolean on = true;

    public TileAirPump() {
        this.tank = new Tank(8000);
        this.inventory = new ItemStack[1];
    }

    public boolean updateAirArea(Type type) {
        this.on = !this.on;
        int total = 0;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int l = 0; l <= 2; ++l) {
                    if ((i == 2 || i == -2) && (j == 2 || j == -2)) continue;
                    int x2 = this.field_145851_c + i;
                    int y2 = this.field_145848_d + l;
                    int z2 = this.field_145849_e + j;
                    if (this.field_145850_b.func_147437_c(x2, y2, z2)) {
                        ++total;
                    }
                    if (type.equals((Object)Type.CHECK)) continue;
                    if (type.equals((Object)Type.DISPLAY_GREEN)) {
                        this.field_145850_b.func_72869_a("happyVillager", (double)x2 + 0.5, (double)y2 + 0.5, (double)z2 + 0.5, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (!type.equals((Object)Type.DISPLAY_RED)) continue;
                    this.field_145850_b.func_72869_a("reddust", (double)x2 + 0.5, (double)y2 + 0.5, (double)z2 + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
        if (type.equals((Object)Type.CHECK)) {
            return total >= 52;
        }
        if (type.equals((Object)Type.DISPLAY)) {
            if (total >= 52) {
                this.updateAirArea(Type.DISPLAY_GREEN);
            } else {
                this.updateAirArea(Type.DISPLAY_RED);
            }
        }
        return true;
    }

    public void supplyWithAir(int value, double x, double y, double z) {
        List playerList;
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != null && !(playerList = this.field_145850_b.func_72872_a(EntityPlayer.class, this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_145838_q().func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).func_72314_b(x, y, z))).isEmpty()) {
            for (int i = 0; i < playerList.size(); ++i) {
                EntityPlayer player = (EntityPlayer)playerList.get(i);
                if (!PlayerHelper.hasArmor(player, ArmorSlot.TOP, Diving.divingTop) || !PlayerHelper.hasArmor(player, ArmorSlot.HAT, Diving.divingHelmet) || !player.func_70055_a(Material.field_151586_h)) continue;
                if (value == 300) {
                    player.func_70050_g(300);
                    continue;
                }
                player.func_70050_g(player.func_70086_ai() + 35);
            }
        }
    }

    public void doPoweredPump(boolean rf) {
        if (rf) {
            if (this.storage.extractEnergy(100, true) < 100) {
                return;
            }
            this.storage.extractEnergy(100, false);
        }
        if (this.updateAirArea(Type.CHECK)) {
            if (Modules.isActive(Modules.diving)) {
                if (rf) {
                    this.supplyWithAir(300, 40.0, 64.0, 40.0);
                } else {
                    this.supplyWithAir(300, 64.0, 128.0, 64.0);
                }
            }
            this.animate = true;
            if (this.canUpdate()) {
                PacketHandler.sendAround(new PacketAirPump(this.field_145851_c, this.field_145848_d, this.field_145849_e), this);
            }
        }
        this.suckUpGas(4096);
        if (this.helper == null) {
            this.helper = new BlockTransferHelper(this);
        }
        this.helper.ejectFluid(new int[]{8000, 4000, 2000, 1000, 100, 20, 1});
    }

    public boolean suckUpGas(int chance) {
        boolean collected = false;
        for (int x = this.field_145851_c - 6; x < this.field_145851_c + 7; ++x) {
            for (int z = this.field_145849_e - 6; z < this.field_145849_e + 7; ++z) {
                for (int y = this.field_145848_d; y < this.field_145848_d + 10; ++y) {
                    if (this.rand.nextInt(1) != 0 || !this.isNaturalGas(x, y, z) || this.fill(ForgeDirection.UP, Fluids.getFluidStack("natural_gas", 1000), false) < 1000) continue;
                    if (!this.field_145850_b.field_72995_K) {
                        this.fill(ForgeDirection.UP, Fluids.getFluidStack("natural_gas", 1000), true);
                        this.field_145850_b.func_147468_f(x, y, z);
                    }
                    collected = true;
                }
            }
        }
        return collected;
    }

    private boolean isNaturalGas(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == Core.air && this.field_145850_b.func_72805_g(x, y, z) == 0;
    }

    public double getWheelAngle(int which) {
        return which == 1 ? this.wheelAngle1 : this.wheelAngle2;
    }

    @Override
    public boolean canUpdate() {
        return Machines.Ticks.PUMP_ENABLE_TICKS;
    }

    public void func_145845_h() {
        if (Machines.Client.PUMP_ANIM && this.animate) {
            this.wheelAngle1 += 0.1;
            this.wheelAngle2 += 0.1;
            if (this.wheelAngle1 > 6.2198) {
                this.wheelAngle1 = 0.0;
                this.animate = false;
            }
            if (this.wheelAngle2 > 6.2198) {
                this.wheelAngle2 = 0.0;
                this.animate = false;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean onTick(int i) {
        return this.tick % i == 0;
    }

    @Override
    public boolean rotate() {
        this.setFacing(BlockHelper.rotate(this.orientation, 4));
        return true;
    }

    @Override
    public ForgeDirection getFacing() {
        return this.orientation;
    }

    @Override
    public void setFacing(ForgeDirection dir) {
        this.orientation = dir;
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.updateOrientation(this);
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int receive = this.storage.receiveEnergy(maxReceive, simulate);
        if (!simulate && this.getEnergyStored(from) > 0) {
            ++this.tick;
            if (this.onTick(300)) {
                this.doPoweredPump(true);
            }
        }
        return receive;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
        this.on = nbt.func_74767_n("DisplayOn");
        this.orientation = ForgeDirection.getOrientation((int)nbt.func_74762_e("Orientation"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
        nbt.func_74757_a("DisplayOn", this.on);
        nbt.func_74768_a("Orientation", this.orientation.ordinal());
    }

    public static enum Type {
        DISPLAY,
        CHECK,
        CLEAR,
        DISPLAY_GREEN,
        DISPLAY_RED;

    }
}

