/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.tile.base;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import java.util.Arrays;
import mariculture.core.tile.base.TileMultiBlock;
import mariculture.core.tile.base.TileMultiMachine;
import mariculture.core.util.IPowered;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileMultiMachinePowered
extends TileMultiMachine
implements IEnergyHandler,
IPowered {
    protected EnergyStorage energyStorage = new EnergyStorage(this.getRFCapacity());
    protected int usage = -1;

    public TileMultiMachinePowered() {
        this.inventory = new ItemStack[4];
        this.offset = 8;
    }

    public abstract int getRFCapacity();

    @Override
    public void updateUpgrades() {
        super.updateUpgrades();
        this.energyStorage.setCapacity(this.getRFCapacity() + this.rf);
        this.updatePowerPerTick();
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.field_145850_b.field_72995_K) {
            TileMultiBlock mstr = this.getMaster();
            if (mstr instanceof TileMultiMachinePowered) {
                TileMultiMachinePowered master = (TileMultiMachinePowered)mstr;
                if (master.usage == -1) {
                    this.updatePowerPerTick();
                }
                int ret = master.energyStorage.receiveEnergy(maxReceive, simulate);
                if (!master.canWork && master.energyStorage.getEnergyStored() >= this.getPowerPerTick() * 2) {
                    master.updateCanWork();
                }
                return ret;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (!this.field_145850_b.field_72995_K) {
            TileMultiBlock mstr = this.getMaster();
            if (mstr instanceof TileMultiMachinePowered) {
                TileMultiMachinePowered master = (TileMultiMachinePowered)mstr;
                int ret = master.energyStorage.extractEnergy(maxExtract, simulate);
                if (ret <= 0) {
                    master.updateCanWork();
                }
                return ret;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.getMaster() != null ? ((TileMultiMachinePowered)this.getMaster()).energyStorage.getEnergyStored() : 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaster() != null ? ((TileMultiMachinePowered)this.getMaster()).energyStorage.getMaxEnergyStored() : 0;
    }

    @Override
    public int getPowerPerTick() {
        return this.usage;
    }

    @Override
    public void updatePowerPerTick() {
        this.usage = (int)(1.05 - (double)(this.rf / 300000) * 0.75);
    }

    @Override
    public boolean isConsumer() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public String getPowerText() {
        return this.getEnergyStored(ForgeDirection.UNKNOWN) + " / " + this.getMaxEnergyStored(ForgeDirection.UNKNOWN) + " RF";
    }

    @Override
    public int getPowerScaled(int i) {
        return this.energyStorage.getEnergyStored() * i / this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public void updateMaster() {
        super.updateMaster();
        if (this.inventory[3] != null) {
            int drain;
            int rf;
            int n = rf = this.inventory[3] != null && this.inventory[3].func_77973_b() instanceof IEnergyContainerItem ? ((IEnergyContainerItem)this.inventory[3].func_77973_b()).extractEnergy(this.inventory[3], 3000, true) : 0;
            if (rf > 0 && (drain = this.receiveEnergy(ForgeDirection.UP, rf, true)) > 0) {
                ((IEnergyContainerItem)this.inventory[3].func_77973_b()).extractEnergy(this.inventory[3], drain, false);
                if (this.inventory[3] == null || this.inventory[3].field_77994_a <= 0) {
                    this.func_70298_a(3, 1);
                }
                this.receiveEnergy(ForgeDirection.UP, drain, false);
            }
        }
    }

    @Override
    public void setGUIData(int id, int value) {
        super.setGUIData(id, value);
        switch (id) {
            case 6: {
                this.energyStorage.setEnergyStored(value);
                break;
            }
            case 7: {
                this.energyStorage.setCapacity(value);
                break;
            }
            case 8: {
                this.usage = value;
            }
        }
    }

    @Override
    public ArrayList<Integer> getGUIData() {
        ArrayList<Integer> list = super.getGUIData();
        list.addAll(new ArrayList<Integer>(Arrays.asList(this.energyStorage.getEnergyStored(), this.energyStorage.getMaxEnergyStored(), this.canWork ? this.getPowerPerTick() : 0)));
        return list;
    }
}

