/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mariculture.core.blocks.base.BlockFunctional;
import mariculture.factory.blocks.BlockCustomHelper;
import mariculture.factory.blocks.BlockItemCustom;
import mariculture.factory.tile.TileCustom;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCustomBase
extends BlockFunctional {
    BlockCustomBase(Material material) {
        super(material);
        this.func_149647_a(null);
    }

    @Override
    public String getToolType(int meta) {
        return "axe";
    }

    @Override
    public int getToolLevel(int meta) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150348_b.func_149691_a(side, meta);
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149701_w() {
        return 0;
    }

    public boolean func_149686_d() {
        return false;
    }

    public IIcon func_149673_e(IBlockAccess block, int x, int y, int z, int side) {
        return BlockCustomHelper.getBlockTexture(block, x, y, z, side);
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entity, stack);
        BlockCustomHelper.onBlockPlacedBy(world, x, y, z, entity, stack);
    }

    @Override
    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        return BlockCustomHelper.rotateBlock(world, x, y, z, axis);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return BlockCustomHelper.getBlockHardness(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return BlockCustomHelper.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return BlockCustomHelper.removeBlockByPlayer(world, player, x, y, z, this.getID());
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return BlockCustomHelper.getPickBlock(target, world, x, y, z, this.getID());
    }

    @Override
    public boolean hasTileEntity(int meta) {
        return true;
    }

    @Override
    public TileEntity createTileEntity(World world, int meta) {
        return new TileCustom();
    }

    public int getID() {
        return 0;
    }

    @Override
    public void func_149651_a(IIconRegister iconRegister) {
    }

    @Override
    public int getMetaCount() {
        return 1;
    }

    @Override
    public boolean isActive(int meta) {
        return true;
    }

    @Override
    public boolean isValidTab(CreativeTabs tab, int meta) {
        return false;
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return BlockItemCustom.class;
    }
}

