/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.tile;

import mariculture.core.handlers.FluidDicHandler;
import mariculture.core.tile.base.TileTank;
import mariculture.core.util.Tank;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileDictionaryFluid
extends TileTank {
    public TileDictionaryFluid() {
        this.tank = new Tank(1);
    }

    public double getCapacity() {
        return this.tank.getCapacity();
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (FluidDicHandler.areSameDicNames(resource, this.tank.getFluid())) {
            int newAmount = FluidDicHandler.getValue(this.tank.getFluid().getFluid().getName());
            int oldAmount = FluidDicHandler.getValue(resource.getFluid().getName());
            int x = this.field_145851_c + from.offsetX;
            int y = this.field_145848_d + from.offsetY;
            int z = this.field_145849_e + from.offsetZ;
            if (this.field_145850_b.func_147438_o(x, y, z) instanceof IFluidHandler && resource.amount >= oldAmount) {
                int drainAmount = Math.min(resource.amount, oldAmount);
                IFluidHandler handler = (IFluidHandler)this.field_145850_b.func_147438_o(x, y, z);
                FluidStack output = new FluidStack(this.tank.getFluid().getFluid(), newAmount);
                if (handler.fill(from.getOpposite(), output, false) == newAmount) {
                    if (doFill) {
                        handler.fill(from, output, true);
                    }
                    return drainAmount;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

