/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mariculture.api.util.CachedCoords;
import mariculture.core.Core;
import mariculture.core.network.PacketHandler;
import mariculture.core.network.PacketRotorSpin;
import mariculture.core.util.IFaceable;
import mariculture.factory.tile.TileGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileRotor
extends TileEntity
implements IFaceable {
    public ForgeDirection orientation = ForgeDirection.NORTH;
    public CachedCoords master;
    public int damage = 0;
    public int isAnimating;
    public ForgeDirection dir;
    public float angle;
    private final int maxDamage;
    private final double tier = this.getTier();

    public TileRotor() {
        this.maxDamage = this.getMaxDamage();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(1.0, 1.0, 1.0);
    }

    public void setAnimating(ForgeDirection dir) {
        this.dir = dir;
        this.isAnimating = 1;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K && this.isAnimating > 0) {
            if (this.dir == ForgeDirection.NORTH) {
                this.angle = (float)((double)this.angle - this.getTier());
            } else if (this.dir == ForgeDirection.SOUTH) {
                this.angle = (float)((double)this.angle + this.getTier());
            } else if (this.dir == ForgeDirection.WEST) {
                this.angle = (float)((double)this.angle - this.getTier());
            } else if (this.dir == ForgeDirection.EAST) {
                this.angle = (float)((double)this.angle + this.getTier());
            }
            ++this.isAnimating;
            if (this.isAnimating > 360) {
                this.isAnimating = 0;
            }
        }
    }

    protected abstract double getTier();

    protected abstract int getMaxDamage();

    public abstract ItemStack getDrop();

    public void setMaster(CachedCoords master) {
        this.master = master;
    }

    public void addEnergy(ForgeDirection dir, int energy, int dmg) {
        TileGenerator generator = this.getMaster();
        if (generator != null) {
            generator.addEnergy((int)((double)energy * this.getTier()));
        }
        this.damage += dmg;
        if (this.damage >= this.maxDamage) {
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Core.metals, 5, 2);
            this.recheck();
        }
        PacketHandler.sendAround(new PacketRotorSpin(this.field_145851_c, this.field_145848_d, this.field_145849_e, dir), this);
    }

    private TileGenerator getMaster() {
        if (this.master != null) {
            TileEntity tile = this.field_145850_b.func_147438_o(this.master.x, this.master.y, this.master.z);
            return (TileGenerator)(tile instanceof TileGenerator ? tile : null);
        }
        return null;
    }

    public void recheck() {
        TileGenerator tile = this.getMaster();
        if (tile instanceof TileGenerator) {
            this.master = null;
            tile.reset();
        }
    }

    public void setDamage(int damage) {
        this.damage = (int)Math.floor(damage * 200);
    }

    @Override
    public boolean rotate() {
        this.orientation = this.orientation == ForgeDirection.NORTH ? ForgeDirection.WEST : ForgeDirection.NORTH;
        return true;
    }

    @Override
    public ForgeDirection getFacing() {
        return this.orientation;
    }

    @Override
    public void setFacing(ForgeDirection dir) {
        switch (dir) {
            case NORTH: 
            case SOUTH: 
            case UP: {
                this.orientation = ForgeDirection.NORTH;
                break;
            }
            case EAST: 
            case WEST: 
            case DOWN: {
                this.orientation = ForgeDirection.WEST;
                break;
            }
            default: {
                this.orientation = ForgeDirection.NORTH;
            }
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74767_n("HasMaster")) {
            int x = nbt.func_74762_e("MasterX");
            int y = nbt.func_74762_e("MasterY");
            int z = nbt.func_74762_e("MasterZ");
            this.master = new CachedCoords(x, y, z);
        }
        this.orientation = ForgeDirection.getOrientation((int)nbt.func_74762_e("Orientation"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.master != null) {
            nbt.func_74757_a("HasMaster", true);
            nbt.func_74768_a("MasterX", this.master.x);
            nbt.func_74768_a("MasterY", this.master.y);
            nbt.func_74768_a("MasterZ", this.master.z);
        } else {
            nbt.func_74757_a("HasMaster", false);
        }
        nbt.func_74768_a("Orientation", this.orientation.ordinal());
    }
}

