/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.tile;

import mariculture.api.core.IBlacklisted;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.cofh.BlockHelper;
import mariculture.core.network.PacketHandler;
import mariculture.core.tile.base.TileTank;
import mariculture.core.util.Fluids;
import mariculture.core.util.IFaceable;
import mariculture.core.util.Tank;
import mariculture.factory.tile.TileRotor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileSluice
extends TileTank
implements IBlacklisted,
IFaceable {
    public ForgeDirection orientation = ForgeDirection.UP;
    protected int height = 0;

    public TileSluice() {
        this.tank = new Tank(10000);
    }

    @Override
    public boolean isBlacklisted(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public boolean onTick(int i) {
        return this.field_145850_b.func_72820_D() % (long)i == 0L;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.onTick(200) && this.orientation.ordinal() > 1) {
                this.generateHPWater();
            }
            if (this.onTick(60)) {
                this.placeInTank();
                this.pullFromTank();
                this.switchTanks();
            }
        }
    }

    public void placeInTank() {
        int z2;
        int y2;
        int x2;
        Block block;
        TileEntity tile = BlockHelper.getAdjacentTileEntity(this, this.orientation);
        if (tile != null && tile instanceof IFluidHandler && ((block = this.field_145850_b.func_147439_a(x2 = this.field_145851_c - this.orientation.offsetX, y2 = this.field_145848_d - this.orientation.offsetY, z2 = this.field_145849_e - this.orientation.offsetZ)) instanceof BlockFluidBase || block instanceof BlockLiquid)) {
            IFluidHandler tank;
            FluidStack fluid = null;
            if (block instanceof BlockFluidBase) {
                fluid = ((BlockFluidBase)block).drain(this.field_145850_b, x2, y2, z2, false);
            }
            if (mariculture.core.helpers.BlockHelper.isWater(this.field_145850_b, x2, y2, z2)) {
                fluid = FluidRegistry.getFluidStack((String)"water", (int)1000);
            }
            if (mariculture.core.helpers.BlockHelper.isLava(this.field_145850_b, x2, y2, z2)) {
                fluid = FluidRegistry.getFluidStack((String)"lava", (int)1000);
            }
            if (fluid != null && (tank = (IFluidHandler)tile).fill(this.orientation, fluid, false) >= fluid.amount) {
                if (block instanceof BlockFluidBase) {
                    ((BlockFluidBase)block).drain(this.field_145850_b, x2, y2, z2, true);
                } else {
                    this.field_145850_b.func_147468_f(x2, y2, z2);
                }
                tank.fill(this.orientation, fluid, true);
            }
        }
    }

    public void pullFromTank() {
        int z2;
        int y2;
        int x2;
        TileEntity tile = BlockHelper.getAdjacentTileEntity(this, this.orientation.getOpposite());
        if (tile != null && tile instanceof IFluidHandler && this.field_145850_b.func_147437_c(x2 = this.field_145851_c + this.orientation.offsetX, y2 = this.field_145848_d + this.orientation.offsetY, z2 = this.field_145849_e + this.orientation.offsetZ)) {
            IFluidHandler tank = (IFluidHandler)tile;
            FluidTankInfo[] info = tank.getTankInfo(this.orientation.getOpposite());
            if (info == null || info.length < 1) {
                return;
            }
            for (FluidTankInfo tanks : info) {
                Block block;
                Fluid fluid;
                if (tanks.fluid == null || (fluid = tanks.fluid.getFluid()) == null || !fluid.canBePlacedInWorld()) continue;
                int drain = FluidHelper.getRequiredVolumeForBlock(fluid);
                FluidStack drainStack = tank.drain(this.orientation.getOpposite(), drain, false);
                if (drainStack == null || drainStack.amount != drain || (block = fluid.getBlock()) == null) continue;
                FluidStack stack = tank.drain(this.orientation.getOpposite(), new FluidStack(fluid.getID(), drain), false);
                if (stack == null) {
                    return;
                }
                if (block instanceof BlockFluidFinite) {
                    if (this.field_145850_b.func_147437_c(x2, y2, z2)) {
                        this.field_145850_b.func_147465_d(x2, y2, z2, block, 0, 2);
                    } else {
                        int meta = this.field_145850_b.func_72805_g(x2, y2, z2) + 1;
                        if (meta < 7 && this.field_145850_b.func_147439_a(x2, y2, z2) == block) {
                            this.field_145850_b.func_72921_c(x2, y2, z2, meta, 2);
                        } else {
                            return;
                        }
                    }
                    tank.drain(this.orientation.getOpposite(), new FluidStack(fluid.getID(), drain), true);
                    continue;
                }
                if (!this.field_145850_b.func_147437_c(x2, y2, z2)) continue;
                this.field_145850_b.func_147449_b(x2, y2, z2, block);
                tank.drain(this.orientation.getOpposite(), new FluidStack(fluid.getID(), drain), true);
            }
        }
    }

    public void switchTanks() {
        int x2 = this.field_145851_c + this.orientation.offsetX;
        int y2 = this.field_145848_d + this.orientation.offsetY;
        int z2 = this.field_145849_e + this.orientation.offsetZ;
        int x3 = this.field_145851_c + this.orientation.getOpposite().offsetX;
        int y3 = this.field_145848_d + this.orientation.getOpposite().offsetY;
        int z3 = this.field_145849_e + this.orientation.getOpposite().offsetZ;
        if (this.field_145850_b.func_147438_o(x2, y2, z2) instanceof IFluidHandler && this.field_145850_b.func_147438_o(x3, y3, z3) instanceof IFluidHandler) {
            IFluidHandler tankFrom = (IFluidHandler)this.field_145850_b.func_147438_o(x3, y3, z3);
            IFluidHandler tankTo = (IFluidHandler)this.field_145850_b.func_147438_o(x2, y2, z2);
            if (tankTo instanceof TileSluice) {
                return;
            }
            FluidStack fluid = tankFrom.drain(this.orientation, 1000, false);
            if (fluid == null) {
                return;
            }
            int drained = tankTo.fill(this.orientation.getOpposite(), fluid, false);
            if (drained > 0) {
                FluidStack drain = tankFrom.drain(this.orientation, drained, true);
                tankTo.fill(this.orientation.getOpposite(), drain, true);
            }
        }
    }

    public boolean isValid(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == Fluids.getFluidBlock("hp_water");
    }

    public int getEnergyGenerated(int distance) {
        return this.height * distance * 10;
    }

    public void generateHPWater() {
        int x = this.field_145851_c + this.orientation.offsetX;
        int z = this.field_145849_e + this.orientation.offsetZ;
        if (mariculture.core.helpers.BlockHelper.isWater(this.field_145850_b, this.field_145851_c - this.orientation.offsetX, this.field_145848_d, this.field_145849_e - this.orientation.offsetZ)) {
            if (mariculture.core.helpers.BlockHelper.isAir(this.field_145850_b, x, this.field_145848_d, z)) {
                this.field_145850_b.func_147449_b(x, this.field_145848_d, z, Fluids.getFluidBlock("hp_water"));
            }
        } else if (mariculture.core.helpers.BlockHelper.isHPWater(this.field_145850_b, x, this.field_145848_d, z)) {
            this.field_145850_b.func_147468_f(x, this.field_145848_d, z);
        }
        if (mariculture.core.helpers.BlockHelper.isHPWater(this.field_145850_b, x, this.field_145848_d, z)) {
            this.height = 0;
            while (mariculture.core.helpers.BlockHelper.isWater(this.field_145850_b, this.field_145851_c - this.orientation.offsetX, this.field_145848_d + this.height, this.field_145849_e - this.orientation.offsetZ)) {
                ++this.height;
            }
        }
        if (this.height > 0) {
            int distance;
            for (distance = 1; this.isValid(this.field_145850_b, this.field_145851_c + this.orientation.offsetX * distance, this.field_145848_d, this.field_145849_e + this.orientation.offsetZ * distance) && distance < 16; ++distance) {
            }
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + this.orientation.offsetX * distance, this.field_145848_d, this.field_145849_e + this.orientation.offsetZ * distance);
            if (tile instanceof TileRotor) {
                ((TileRotor)tile).addEnergy(this.orientation.getOpposite(), this.getEnergyGenerated(distance), 200);
            }
        }
    }

    @Override
    public boolean rotate() {
        this.setFacing(mariculture.core.helpers.BlockHelper.rotate(this.orientation));
        return true;
    }

    @Override
    public ForgeDirection getFacing() {
        return this.orientation;
    }

    @Override
    public void setFacing(ForgeDirection dir) {
        this.orientation = dir;
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.updateOrientation(this);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.orientation = ForgeDirection.values()[nbt.func_74762_e("Orientation")];
        this.height = nbt.func_74762_e("Height");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Orientation", this.orientation.ordinal());
        nbt.func_74768_a("Height", this.height);
    }
}

