/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.tile;

import java.util.LinkedList;
import mariculture.api.util.CachedCoords;
import mariculture.core.config.Machines;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.cofh.BlockHelper;
import mariculture.factory.tile.TileSluice;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class TileSluiceAdvanced
extends TileSluice {
    public LinkedList<CachedCoords> todo;

    @Override
    public void func_145845_h() {
        if (this.onTick(150) && this.orientation.ordinal() > 1) {
            this.generateHPWater();
        }
        if (this.onTick(Machines.Ticks.ADVANCED_SLUICE_TICK)) {
            if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.placeInTank();
            } else {
                this.pullFromTank();
            }
            this.switchTanks();
        }
    }

    @Override
    public int getEnergyGenerated(int distance) {
        return super.getEnergyGenerated(distance) * 4;
    }

    private void addToList(int x, int y, int z) {
        CachedCoords coord = new CachedCoords(x, y, z);
        if (!this.todo.contains(coord)) {
            this.todo.add(coord);
        }
    }

    private boolean isValid(World world, int x, int y, int z, boolean drain) {
        if (drain) {
            Block block = world.func_147439_a(x, y, z);
            if (block instanceof IFluidBlock || block instanceof BlockStaticLiquid) {
                return world.func_72805_g(x, y, z) == 0;
            }
            return false;
        }
        return this.canBeReplaced(x, y, z);
    }

    private void updateArea(boolean drain) {
        this.todo = new LinkedList();
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        if (drain) {
            x = this.field_145851_c + this.orientation.getOpposite().offsetX;
            y = this.field_145848_d + this.orientation.getOpposite().offsetY;
            z = this.field_145849_e + this.orientation.getOpposite().offsetZ;
        } else {
            x = this.field_145851_c + this.orientation.offsetX;
            y = this.field_145848_d + this.orientation.offsetY;
            z = this.field_145849_e + this.orientation.offsetZ;
        }
        if (this.isValid(this.field_145850_b, x, y, z, drain)) {
            this.addToList(x, y, z);
            int loop = !drain ? Machines.MachineSettings.ADVANCED_SLUICE_RADIUS / 2 : Machines.MachineSettings.ADVANCED_SLUICE_RADIUS;
            for (int j = 0; j < loop; ++j) {
                LinkedList temp = (LinkedList)this.todo.clone();
                for (CachedCoords coord : temp) {
                    if (this.isValid(this.field_145850_b, coord.x + 1, coord.y, coord.z, drain)) {
                        this.addToList(coord.x + 1, coord.y, coord.z);
                    }
                    if (this.isValid(this.field_145850_b, coord.x - 1, coord.y, coord.z, drain)) {
                        this.addToList(coord.x - 1, coord.y, coord.z);
                    }
                    if (this.isValid(this.field_145850_b, coord.x, coord.y, coord.z + 1, drain)) {
                        this.addToList(coord.x, coord.y, coord.z + 1);
                    }
                    if (this.isValid(this.field_145850_b, coord.x, coord.y, coord.z - 1, drain)) {
                        this.addToList(coord.x, coord.y, coord.z - 1);
                    }
                    if (drain) {
                        if (!this.isValid(this.field_145850_b, coord.x, coord.y + 1, coord.z, drain)) continue;
                        this.addToList(coord.x, coord.y + 1, coord.z);
                        continue;
                    }
                    if (!this.isValid(this.field_145850_b, coord.x, coord.y - 1, coord.z, drain)) continue;
                    this.addToList(coord.x, coord.y - 1, coord.z);
                }
            }
        }
    }

    private CachedCoords getNextCoordinates(boolean drain) {
        CachedCoords cord = null;
        if (this.todo == null || this.todo.size() <= 0) {
            this.updateArea(drain);
        }
        if (this.todo != null && this.todo.size() > 0) {
            cord = this.todo.getLast();
            this.todo.removeLast();
        }
        return cord;
    }

    @Override
    public void placeInTank() {
        int z2;
        int y2;
        int x2;
        Block block;
        CachedCoords cord;
        if (!Machines.MachineSettings.ENABLE_ADVANCED_SLUICE_DRAIN) {
            super.placeInTank();
            return;
        }
        TileEntity tile = BlockHelper.getAdjacentTileEntity(this, this.orientation);
        if (tile != null && tile instanceof IFluidHandler && (cord = this.getNextCoordinates(true)) != null && ((block = this.field_145850_b.func_147439_a(x2 = cord.x, y2 = cord.y, z2 = cord.z)) instanceof BlockFluidBase || block instanceof BlockLiquid)) {
            IFluidHandler tank;
            FluidStack fluid = null;
            if (block instanceof BlockFluidBase) {
                fluid = ((BlockFluidBase)block).drain(this.field_145850_b, x2, y2, z2, false);
            }
            if (mariculture.core.helpers.BlockHelper.isWater(this.field_145850_b, x2, y2, z2)) {
                fluid = FluidRegistry.getFluidStack((String)"water", (int)1000);
            }
            if (mariculture.core.helpers.BlockHelper.isLava(this.field_145850_b, x2, y2, z2)) {
                fluid = FluidRegistry.getFluidStack((String)"lava", (int)1000);
            }
            if (fluid != null && (tank = (IFluidHandler)tile).fill(this.orientation, fluid, false) >= fluid.amount) {
                if (block instanceof BlockFluidBase) {
                    ((BlockFluidBase)block).drain(this.field_145850_b, x2, y2, z2, true);
                } else {
                    this.field_145850_b.func_147468_f(x2, y2, z2);
                }
                tank.fill(this.orientation, fluid, true);
            }
        }
    }

    private boolean canBeReplaced(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (block instanceof IFluidBlock || block instanceof BlockStaticLiquid) {
            return this.field_145850_b.func_72805_g(x, y, z) != 0;
        }
        return this.field_145850_b.func_147437_c(x, y, z);
    }

    @Override
    public void pullFromTank() {
        int z2;
        int y2;
        int x2;
        CachedCoords cord;
        TileEntity tile = BlockHelper.getAdjacentTileEntity(this, this.orientation.getOpposite());
        if (tile != null && tile instanceof IFluidHandler && (cord = this.getNextCoordinates(false)) != null && this.canBeReplaced(x2 = cord.x, y2 = cord.y, z2 = cord.z)) {
            IFluidHandler tank = (IFluidHandler)tile;
            FluidTankInfo[] info = tank.getTankInfo(this.orientation.getOpposite());
            if (info == null || info.length < 1) {
                return;
            }
            for (FluidTankInfo tanks : info) {
                Block block;
                Fluid fluid;
                if (tanks.fluid == null || (fluid = tanks.fluid.getFluid()) == null || !fluid.canBePlacedInWorld()) continue;
                int drain = FluidHelper.getRequiredVolumeForBlock(fluid);
                FluidStack drainStack = tank.drain(this.orientation.getOpposite(), drain, false);
                if (drainStack == null || drainStack.amount != drain || (block = fluid.getBlock()) == null) continue;
                FluidStack stack = tank.drain(this.orientation.getOpposite(), new FluidStack(fluid.getID(), drain), false);
                if (stack == null) {
                    return;
                }
                if (block instanceof BlockFluidFinite) {
                    if (this.field_145850_b.func_147437_c(x2, y2, z2)) {
                        this.field_145850_b.func_147465_d(x2, y2, z2, block, 0, 2);
                    } else {
                        int meta = this.field_145850_b.func_72805_g(x2, y2, z2) + 1;
                        if (meta < 7 && this.field_145850_b.func_147439_a(x2, y2, z2) == block) {
                            this.field_145850_b.func_72921_c(x2, y2, z2, meta, 2);
                        } else {
                            return;
                        }
                    }
                    tank.drain(this.orientation.getOpposite(), new FluidStack(fluid.getID(), drain), true);
                    continue;
                }
                if (!this.canBeReplaced(x2, y2, z2)) continue;
                this.field_145850_b.func_147449_b(x2, y2, z2, block);
                tank.drain(this.orientation.getOpposite(), new FluidStack(fluid.getID(), drain), true);
            }
        }
    }
}

