/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import mariculture.api.fishery.Fishing;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ShapelessFishRecipe
implements IRecipe {
    private ItemStack output = null;
    private ArrayList input = new ArrayList();

    public ShapelessFishRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapelessFishRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapelessFishRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            String ret = "Invalid shapeless ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    ShapelessFishRecipe(ShapelessRecipes recipe, Map<ItemStack, String> replacements) {
        this.output = recipe.func_77571_b();
        Iterator i$ = recipe.field_77579_b.iterator();
        while (i$.hasNext()) {
            ItemStack ingred;
            Object finalObj = ingred = (ItemStack)i$.next();
            for (Map.Entry<ItemStack, String> replace : replacements.entrySet()) {
                if (!OreDictionary.itemMatches((ItemStack)replace.getKey(), (ItemStack)ingred, (boolean)false)) continue;
                finalObj = OreDictionary.getOres((String)replace.getValue());
                break;
            }
            this.input.add(finalObj);
        }
    }

    public int func_77570_a() {
        return this.input.size();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack getRecipeOutput(ItemStack egg) {
        if (egg.func_77942_o()) {
            int eggs = egg.field_77990_d.func_74762_e("currentFertility");
            this.output.field_77994_a = (int)Math.max(1.0, Math.ceil(eggs / 650));
        }
        return this.output.func_77946_l();
    }

    public ItemStack func_77572_b(InventoryCrafting crafting) {
        for (int i = 0; i < crafting.func_70302_i_(); ++i) {
            ItemStack stack = crafting.func_70301_a(i);
            if (stack == null || !Fishing.fishHelper.isEgg(stack)) continue;
            return this.getRecipeOutput(stack);
        }
        return null;
    }

    public boolean func_77569_a(InventoryCrafting var1, World world) {
        ArrayList required = new ArrayList(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = this.checkItemEquals((ItemStack)next, slot);
                } else if (next instanceof ArrayList) {
                    for (ItemStack item : (ArrayList)next) {
                        match = match || this.checkItemEquals(item, slot);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        return target.func_77973_b() == input.func_77973_b() && (target.func_77960_j() == Short.MAX_VALUE || target.func_77960_j() == input.func_77960_j());
    }

    public ArrayList getInput() {
        return this.input;
    }
}

