/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import java.util.ArrayList;
import mariculture.api.core.Environment;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.api.util.CachedCoords;
import mariculture.core.lib.ItemLib;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FishBoneless
extends FishSpecies {
    @Override
    public int[] setSuitableTemperature() {
        return new int[]{-5, 20};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH, Environment.Salinity.BRACKISH};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 30;
    }

    @Override
    public int getFertility() {
        return 50;
    }

    @Override
    public int getFoodConsumption() {
        return 0;
    }

    @Override
    public boolean requiresFood() {
        return false;
    }

    @Override
    public int getWaterRequired() {
        return 150;
    }

    @Override
    public int getAreaOfEffectBonus(ForgeDirection dir) {
        return dir == ForgeDirection.UP || dir == ForgeDirection.DOWN ? 1 : 0;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(ItemLib.dropletEarth, 1.0);
        this.addProduct(ItemLib.bonemeal, 5.0);
        this.addProduct(ItemLib.bone, 1.5);
        this.addProduct(ItemLib.skull, 1.0);
        this.addProduct(ItemLib.witherSkull, 0.1);
    }

    @Override
    public double getFishOilVolume() {
        return 0.0;
    }

    @Override
    public int getLiquifiedProductChance() {
        return 1;
    }

    @Override
    public int getFishMealSize() {
        return 0;
    }

    @Override
    public int getFoodStat() {
        return -1;
    }

    @Override
    public void affectWorld(World world, int x, int y, int z, ArrayList<CachedCoords> coords) {
        if (world.field_73012_v.nextInt(500) == 0) {
            EntitySkeleton skeleton = new EntitySkeleton(world);
            skeleton.func_70107_b((double)x, (double)y, (double)z);
            if (world.field_73012_v.nextInt(5000) == 0) {
                skeleton.func_82201_a(1);
                skeleton.func_70062_b(0, new ItemStack(Items.field_151052_q));
                skeleton.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
            }
            world.func_72838_d((Entity)skeleton);
        }
    }

    @Override
    public boolean canWorkAtThisTime(boolean isDay) {
        return !isDay;
    }

    @Override
    public RodType getRodNeeded() {
        return RodType.FLUX;
    }

    @Override
    public double getCatchChance(World world, int height) {
        return Environment.Height.isCave(height) ? 10.0 : (!world.func_72935_r() ? 10.0 : 0.0);
    }
}

