/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.ItemLib;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FishClown
extends FishSpecies {
    @Override
    public int[] setSuitableTemperature() {
        return new int[]{24, 27};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.SALINE, Environment.Salinity.BRACKISH};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 7;
    }

    @Override
    public int getFertility() {
        return 2000;
    }

    @Override
    public int getBaseProductivity() {
        return 0;
    }

    @Override
    public int getFoodConsumption() {
        return 2;
    }

    @Override
    public int getWaterRequired() {
        return 200;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(ItemLib.dropletWater, 3.0);
        this.addProduct(ItemLib.dropletAqua, 2.0);
        this.addProduct(ItemLib.dropletRegen, 2.5);
        this.addProduct(ItemLib.dropletMagic, 1.0);
    }

    @Override
    public double getFishOilVolume() {
        return 1.8;
    }

    @Override
    public ItemStack getLiquifiedProduct() {
        return ItemLib.orangeDye;
    }

    @Override
    public int getLiquifiedProductChance() {
        return 3;
    }

    @Override
    public boolean canWorkAtThisTime(boolean isDay) {
        return isDay;
    }

    @Override
    public RodType getRodNeeded() {
        return RodType.DIRE;
    }

    @Override
    public double getCatchChance(World world, int height) {
        return Environment.Height.isShallows(height) ? 20.0 : 0.0;
    }
}

