/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import mariculture.api.core.Environment;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.api.util.CachedCoords;
import mariculture.core.lib.ItemLib;
import mariculture.core.util.PowerHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FishElectricRay
extends FishSpecies {
    @Override
    public int[] setSuitableTemperature() {
        return new int[]{5, 21};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.SALINE, Environment.Salinity.BRACKISH, Environment.Salinity.FRESH};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 20;
    }

    @Override
    public int getFertility() {
        return 4000;
    }

    @Override
    public int getFoodConsumption() {
        return 2;
    }

    @Override
    public int getWaterRequired() {
        return 175;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(ItemLib.dropletWater, 5.0);
        this.addProduct(ItemLib.dropletRegen, 1.0);
        this.addProduct(ItemLib.dropletFlux, 4.0);
    }

    @Override
    public double getFishOilVolume() {
        return 6.675;
    }

    @Override
    public int getFishMealSize() {
        return 5;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        world.func_72942_c((Entity)new EntityLightningBolt(world, player.field_70165_t, player.field_70163_u, player.field_70161_v));
    }

    @Override
    public void affectWorld(World world, int x, int y, int z, ArrayList<CachedCoords> coords) {
        IEnergyHandler handler;
        if (world.field_73012_v.nextInt(512) == 0) {
            world.func_72942_c((Entity)new EntityLightningBolt(world, (double)(x + world.field_73012_v.nextInt(5) - world.field_73012_v.nextInt(10)), (double)y, (double)(z + world.field_73012_v.nextInt(5) - world.field_73012_v.nextInt(10))));
        }
        if (PowerHelper.isEnergyHandler(world, x, y - 1, z) != null && (handler = PowerHelper.isEnergyHandler(world, x, y - 1, z)).canConnectEnergy(ForgeDirection.DOWN)) {
            handler.receiveEnergy(ForgeDirection.UP, 200, false);
        }
    }

    @Override
    public RodType getRodNeeded() {
        return RodType.FLUX;
    }

    @Override
    public double getCatchChance(World world, int height) {
        return 8.0;
    }
}

