/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.ItemLib;
import net.minecraft.world.World;

public class FishMinnow
extends FishSpecies {
    @Override
    public int[] setSuitableTemperature() {
        return new int[]{-1, 45};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 5;
    }

    @Override
    public int getFertility() {
        return 1000;
    }

    @Override
    public int getBaseProductivity() {
        return 2;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(ItemLib.dropletWater, 15.0);
    }

    @Override
    public double getFishOilVolume() {
        return 0.24;
    }

    @Override
    public int getFishMealSize() {
        return 1;
    }

    @Override
    public RodType getRodNeeded() {
        return RodType.OLD;
    }

    @Override
    public double getCatchChance(World world, int height) {
        if (world.func_72935_r()) {
            return 33.0;
        }
        return 5.0;
    }

    @Override
    public double getCaughtAliveChance(World world, int height) {
        return world.func_72935_r() && height > 70 ? 85.0 : 25.0;
    }
}

