/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.ItemLib;
import mariculture.core.lib.MaricultureDamage;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class FishPiranha
extends FishSpecies {
    @Override
    public int[] setSuitableTemperature() {
        return new int[]{21, 28};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 10;
    }

    @Override
    public int getFertility() {
        return 5000;
    }

    @Override
    public int getFoodConsumption() {
        return 3;
    }

    @Override
    public int getWaterRequired() {
        return 250;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(ItemLib.dropletWater, 3.0);
        this.addProduct(ItemLib.dropletAqua, 2.5);
        this.addProduct(ItemLib.dropletDestroy, 5.0);
        this.addProduct(ItemLib.dropletEarth, 4.0);
        this.addProduct(ItemLib.rottenFlesh, 15.0);
    }

    @Override
    public double getFishOilVolume() {
        return 3.5;
    }

    @Override
    public int getFishMealSize() {
        return 3;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        player.func_70690_d(new PotionEffect(Potion.field_76433_i.field_76415_H, 20, 0));
    }

    @Override
    public void affectLiving(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_70170_p.field_73013_u.ordinal() > 0) {
                player.func_70097_a(MaricultureDamage.piranha, (float)player.field_70170_p.field_73013_u.ordinal());
            }
        } else {
            entity.func_70097_a(MaricultureDamage.piranha, 2.0f);
        }
    }

    @Override
    public RodType getRodNeeded() {
        return RodType.FLUX;
    }

    @Override
    public double getCatchChance(World world, int height) {
        return !world.func_72935_r() ? 35.0 : 3.0;
    }
}

